/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.jar;

import com.norconex.commons.lang.file.FileUtil;
import com.norconex.commons.lang.jar.JarDuplicateFinder;
import com.norconex.commons.lang.jar.JarDuplicates;
import com.norconex.commons.lang.jar.JarFile;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JarCopier {
    private static final Logger LOG = LogManager.getLogger(JarCopier.class);
    public static final int STRATEGY_RENAME_COPY = 1;
    public static final int STRATEGY_DELETE_COPY = 2;
    public static final int STRATEGY_NO_COPY = 3;
    public static final int STRATEGY_PLAIN_COPY = 4;
    public static final int STRATEGY_INTERACTIVE = 5;
    private final int strategy;
    private final Scanner scanner;

    public JarCopier() {
        this(1);
    }

    public JarCopier(int strategy) {
        if (strategy < 1 || strategy > 5) {
            throw new IllegalArgumentException("Invalid strategy: " + strategy);
        }
        this.strategy = strategy;
        this.scanner = strategy == 5 ? new Scanner(System.in) : null;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void copyJarDirectory(String fromJarDirectory, String toJarDirectory) throws IOException {
        this.copyJarDirectory(new File(fromJarDirectory), new File(toJarDirectory));
    }

    public void copyJarDirectory(File fromJarDirectory, File toJarDirectory) throws IOException {
        if (!fromJarDirectory.isDirectory()) {
            this.error("Invalid source directory: " + fromJarDirectory);
            return;
        }
        if (!toJarDirectory.isDirectory()) {
            this.error("Invalid target directory: " + toJarDirectory);
            return;
        }
        Object[] jarsToCopy = fromJarDirectory.listFiles(JarFile.FILTER);
        if (ArrayUtils.isEmpty((Object[])jarsToCopy)) {
            this.error("No jar files were found in " + fromJarDirectory);
            return;
        }
        List<JarDuplicates> dups = JarDuplicateFinder.findJarDuplicates(fromJarDirectory, toJarDirectory);
        this.info(String.format("%d duplicate jar(s) found.", dups.size()));
        int copyStrategy = this.strategy;
        if (this.strategy == 5 && !dups.isEmpty()) {
            copyStrategy = this.getDuplicatesHandlingUserGlobalChoice();
        }
        for (Object file : jarsToCopy) {
            JarDuplicates dup = this.getDuplicates(dups, (File)file);
            this.copyJarFile((File)file, toJarDirectory, dup, copyStrategy);
        }
        this.info("---");
        this.info("DONE");
    }

    public void copyJarFile(String sourceJarFile, String toDirectory) throws IOException {
        this.copyJarFile(new File(sourceJarFile), new File(toDirectory));
    }

    public void copyJarFile(File sourceJarFile, File toDirectory) throws IOException {
        if (!sourceJarFile.isFile() || !sourceJarFile.getName().endsWith(".jar")) {
            this.error("File does not appear to be a Jar: " + sourceJarFile);
            return;
        }
        if (!toDirectory.isDirectory()) {
            this.error("Invalid target directory: " + toDirectory);
            return;
        }
        List<JarDuplicates> dups = JarDuplicateFinder.findJarDuplicates(sourceJarFile, toDirectory);
        this.info(String.format("%d duplicate jar(s) found.", dups.size()));
        JarDuplicates dup = this.getDuplicates(dups, sourceJarFile);
        this.copyJarFile(sourceJarFile, toDirectory, dup, this.strategy);
        this.info("---");
        this.info("DONE");
    }

    private void copyJarFile(File file, File targetDir, JarDuplicates dups, int copyStragegy) throws IOException {
        this.info("---");
        if (dups == null) {
            this.copy(file, targetDir);
            return;
        }
        JarFile sourceJar = this.getSourceJarFile(dups, file);
        JarFile targetJar = this.getTargetJarFile(dups, file);
        this.info("Duplicate:");
        this.info("  Source: " + sourceJar.getPath().getName());
        this.info("  Target: " + targetJar.getPath().getName());
        boolean copyOnlyIfSourceIsGreater = true;
        int finalStrategy = copyStragegy;
        if (finalStrategy == 5) {
            finalStrategy = this.getDuplicatesHandlingUserFileChoice();
            copyOnlyIfSourceIsGreater = false;
        }
        if (finalStrategy == 1) {
            if (!copyOnlyIfSourceIsGreater || sourceJar.isVersionGreaterThan(targetJar)) {
                this.renameToBackup(targetJar);
                this.copy(file, targetDir);
            } else {
                this.info("No copy: target version is greater for \"" + file + "\".");
            }
            return;
        }
        if (finalStrategy == 2) {
            if (!copyOnlyIfSourceIsGreater || sourceJar.isVersionGreaterThan(targetJar)) {
                this.delete(targetJar);
                this.copy(file, targetDir);
            } else {
                this.info("No copy: target version is greater for \"" + file + "\".");
            }
            return;
        }
        if (finalStrategy == 3) {
            this.info("No copy for \"" + file + "\".");
            return;
        }
        if (finalStrategy == 4) {
            this.copy(file, targetDir);
            return;
        }
    }

    private void copy(File sourceFile, File targetDir) throws IOException {
        this.info("Copying \"" + sourceFile + "\".");
        FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDir, (boolean)true);
    }

    private void delete(JarFile file) throws IOException {
        this.info("Deleting \"" + file.getPath() + "\".");
        FileUtil.delete(file.getPath());
    }

    private void renameToBackup(JarFile file) throws IOException {
        File renamedFile = new File(file.getPath().getAbsolutePath() + ".bak-" + this.createTimestamp());
        this.info("Renaming \"" + file.getPath().getName() + "\" to \"" + renamedFile.getName() + "\".");
        if (!file.getPath().renameTo(renamedFile)) {
            throw new IOException("Could not rename from \"" + file + "\" to \"" + renamedFile + "\".");
        }
    }

    private String createTimestamp() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    private JarFile getSourceJarFile(JarDuplicates dups, File sourceFile) {
        for (JarFile jarFile : dups.getJarFiles()) {
            if (!jarFile.getPath().equals(sourceFile)) continue;
            return jarFile;
        }
        return null;
    }

    private JarFile getTargetJarFile(JarDuplicates dups, File sourceFile) {
        for (JarFile jarFile : dups.getJarFiles()) {
            if (jarFile.getPath().equals(sourceFile)) continue;
            return jarFile;
        }
        return null;
    }

    private int getDuplicatesHandlingUserGlobalChoice() {
        int choice;
        this.info("");
        this.info("How do you want to handle duplicates? For each Jar...");
        this.info("");
        this.info("  1) Copy source Jar only if greater or same version as target");
        this.info("     Jar after renaming target Jar (preferred option).");
        this.info("");
        this.info("  2) Copy source Jar only if greater or same version as target");
        this.info("     Jar after deleting target Jar.");
        this.info("");
        this.info("  3) Do not copy source Jar (leave target Jar as is).");
        this.info("");
        this.info("  4) Copy source Jar regardless of target Jar");
        this.info("     (may overwrite or cause mixed versions).");
        this.info("");
        this.info("  5) Let me choose for each files.");
        while (true) {
            this.info("");
            System.out.print("Your choice (default = 1): ");
            String choiceStr = this.scanner.nextLine();
            if (StringUtils.isEmpty((CharSequence)choiceStr)) {
                return 1;
            }
            choice = NumberUtils.toInt((String)choiceStr);
            if (choice >= 1 && choice <= 5) break;
            this.info("");
            this.info("Wrong selection! Try again.");
        }
        return choice;
    }

    private int getDuplicatesHandlingUserFileChoice() {
        int choice;
        this.info("");
        this.info("Your action:");
        this.info("");
        this.info("  1) Copy source Jar after renaming target Jar.");
        this.info("");
        this.info("  2) Copy source Jar after deleting target Jar.");
        this.info("");
        this.info("  3) Do not copy source Jar (leave target Jar as is).");
        this.info("");
        this.info("  4) Copy source Jar regardless of target Jar (may overwrite");
        this.info("     or cause mixed versions, usually not recommended).");
        while (true) {
            this.info("");
            System.out.print("Your choice (default = 1): ");
            String choiceStr = this.scanner.nextLine();
            if (StringUtils.isEmpty((CharSequence)choiceStr)) {
                return 1;
            }
            choice = NumberUtils.toInt((String)choiceStr);
            if (choice >= 1 && choice <= 4) break;
            this.info("");
            this.info("Wrong selection! Try again.");
        }
        return choice;
    }

    private JarDuplicates getDuplicates(List<JarDuplicates> dups, File jar) {
        for (JarDuplicates dup : dups) {
            if (!dup.contains(jar)) continue;
            return dup;
        }
        return null;
    }

    private void error(String error) {
        if (this.strategy == 5) {
            System.err.println(error);
        } else {
            LOG.error((Object)error);
        }
    }

    private void info(String info) {
        if (this.strategy == 5) {
            System.out.println(info);
        } else {
            LOG.info((Object)info);
        }
    }

    public static void main(String[] args) throws IOException {
        File target;
        File source;
        boolean isSourceDirectory;
        if (args.length < 1) {
            System.err.println("Missing argument(s).");
            System.out.println("");
            System.out.println("Usage:");
            System.out.println("");
            System.out.println("  <app> path1 [path2]");
            System.out.println("");
            System.out.println("Where path1 can either point to a Jar or directory, and path2 must be a directory.");
            System.out.println("\"path2\" is optional: if not provided, you will be prompted for it.");
            System.exit(-1);
        }
        if (!(isSourceDirectory = (source = new File(args[0])).isDirectory())) {
            JarCopier.validateCommandLineJarPath(source);
        }
        if (!(target = args.length == 2 ? new File(args[1]) : JarCopier.getDirectoryFromCommandLinePrompt()).exists()) {
            System.out.println("The target directory does not exist and will be created.");
            target.mkdirs();
        }
        JarCopier jarCopier = new JarCopier(5);
        if (isSourceDirectory) {
            jarCopier.copyJarDirectory(source, target);
        } else {
            jarCopier.copyJarFile(source, target);
        }
    }

    private static File getDirectoryFromCommandLinePrompt() {
        System.out.println("Please enter a target directory:");
        Scanner scanner = new Scanner(System.in);
        File file = new File(scanner.nextLine());
        if (file.exists() && !file.isDirectory()) {
            System.err.println("Path already exists and is not a directory: " + file);
            System.exit(-1);
        }
        return file;
    }

    private static void validateCommandLineJarPath(File path) {
        if (path.isFile() && path.getName().endsWith(".jar")) {
            return;
        }
        System.err.println("Path not a valid/existing Jar or directory: " + path.getAbsolutePath());
        System.exit(-1);
    }
}

