/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.jar;

import com.norconex.commons.lang.jar.JarDuplicates;
import com.norconex.commons.lang.jar.JarFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.multimap.AbstractSetValuedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class JarDuplicateFinder {
    private static final Logger LOG = LogManager.getLogger(JarDuplicateFinder.class);

    private JarDuplicateFinder() {
    }

    public static List<JarDuplicates> findJarDuplicates(String ... jarPaths) {
        if (ArrayUtils.isEmpty((Object[])jarPaths)) {
            return new ArrayList<JarDuplicates>();
        }
        File[] dirs = new File[jarPaths.length];
        for (int i = 0; i < jarPaths.length; ++i) {
            dirs[i] = new File(jarPaths[i]);
        }
        return JarDuplicateFinder.findJarDuplicates(dirs);
    }

    public static List<JarDuplicates> findJarDuplicates(File ... jarPaths) {
        HashTreeValuedHashMap allJars = new HashTreeValuedHashMap();
        for (File path : jarPaths) {
            File[] jars;
            if (path.isDirectory()) {
                jars = path.listFiles(JarFile.FILTER);
            } else if (path.isFile() && JarFile.FILTER.accept(path)) {
                jars = new File[]{path};
            } else {
                jars = new File[]{};
                LOG.warn((Object)("Path is not a valid jar file or directory: " + path));
            }
            for (File jar : jars) {
                JarFile jarFile = new JarFile(jar);
                allJars.put(jarFile.getBaseName(), jarFile);
            }
        }
        JarFile[] emptyJarFiles = new JarFile[]{};
        ArrayList<JarDuplicates> dups = new ArrayList<JarDuplicates>();
        for (String baseName : allJars.keySet()) {
            Collection jarFiles = allJars.get(baseName);
            if (jarFiles.size() <= 1) continue;
            dups.add(new JarDuplicates(jarFiles.toArray(emptyJarFiles)));
        }
        return dups;
    }

    public static void main(String[] args) {
        List<JarDuplicates> dups = JarDuplicateFinder.findJarDuplicates(args);
        System.out.println("Found " + dups.size() + " Jar(s) having one or more duplicates.");
        for (JarDuplicates jarDuplicates : dups) {
            System.out.println();
            System.out.println(jarDuplicates.getLatestVersion().getBaseName() + ":");
            for (JarFile jarFile : jarDuplicates.getJarFiles()) {
                if (jarDuplicates.hasVersionConflict() && jarDuplicates.getLatestVersion().equals(jarFile)) {
                    System.out.print(" * ");
                } else {
                    System.out.print("   ");
                }
                System.out.println(jarFile.getPath() + " [" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(jarFile.getLastModified()) + "]");
            }
        }
    }

    private static class HashTreeValuedHashMap<K, V>
    extends AbstractSetValuedMap<K, V> {
        public HashTreeValuedHashMap() {
            super(new HashMap());
        }

        protected Set<V> createCollection() {
            return new TreeSet();
        }
    }
}

