/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.jar;

import com.norconex.commons.lang.jar.JarFile;
import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class JarDuplicates {
    private final JarFile[] jarFiles;

    public JarDuplicates(JarFile ... jarFiles) {
        if (ArrayUtils.isEmpty((Object[])jarFiles) || jarFiles.length < 2) {
            throw new IllegalArgumentException("Must have 2 or more jar files.");
        }
        this.jarFiles = jarFiles;
    }

    public JarFile[] getJarFiles() {
        return this.jarFiles;
    }

    public JarFile getLatestVersion() {
        return this.jarFiles[0];
    }

    public boolean hasVersionConflict() {
        if (ArrayUtils.isEmpty((Object[])this.jarFiles)) {
            return false;
        }
        JarFile firstJar = this.jarFiles[0];
        for (JarFile jarFile : this.jarFiles) {
            if (firstJar.isSameVersionAndTime(jarFile)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(File jarFile) {
        for (JarFile jar : this.jarFiles) {
            if (!Objects.equals(jar.getPath(), jarFile)) continue;
            return true;
        }
        return false;
    }
}

