/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.jar;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.math.NumberUtils;

public class JarFile
implements Comparable<JarFile> {
    public static final FileFilter FILTER = new SuffixFileFilter(".jar");
    private final File path;
    private final String fullName;
    private final String baseName;
    private final String version;
    private final Version comparableVersion;

    public JarFile(File jarFile) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile argument cannot be null.");
        }
        if (!jarFile.isFile()) {
            throw new IllegalArgumentException("jarFile must be a valid file: " + jarFile);
        }
        if (!jarFile.getName().endsWith(".jar")) {
            throw new IllegalArgumentException("jarFile must end with .jar extension: " + jarFile);
        }
        this.path = jarFile;
        this.fullName = jarFile.getName();
        Pattern p = Pattern.compile("(.*?)-(\\d[\\.\\d\\w-]*)\\.jar");
        Matcher m = p.matcher(this.fullName);
        if (m.find()) {
            String jarName = m.group(1);
            String jarVersion = m.group(2);
            this.baseName = jarName;
            this.version = jarVersion;
        } else {
            this.baseName = this.fullName;
            this.version = null;
        }
        this.comparableVersion = new Version(this.version, this.path.lastModified());
    }

    public File getPath() {
        return this.path;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getLastModified() {
        return new Date(this.path.lastModified());
    }

    public boolean isVersionGreaterThan(JarFile file) {
        return this.compareTo(file) < 0;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof JarFile)) {
            return false;
        }
        JarFile castOther = (JarFile)other;
        return this.path.equals(castOther.getPath());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).toHashCode();
    }

    public boolean isSameVersion(JarFile jarFile) {
        if (jarFile == null) {
            return false;
        }
        return this.fullName.equals(jarFile.fullName);
    }

    public boolean isSameVersionAndTime(JarFile jarFile) {
        return this.isSameVersion(jarFile) && this.path.lastModified() == jarFile.path.lastModified();
    }

    @Override
    public int compareTo(JarFile o) {
        int result = this.comparableVersion.compareTo(o.comparableVersion);
        if (result != 0) {
            return result;
        }
        return this.path.compareTo(o.path);
    }

    private class Version
    implements Comparable<Version> {
        private Object[] segments;
        private long lastModified;

        public Version(String version, long lastModified) {
            this.lastModified = lastModified;
            if (version == null) {
                this.segments = new Object[0];
            } else {
                String[] parts = StringUtils.split((String)version, (String)".-");
                this.segments = new Object[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    this.segments[i] = NumberUtils.isDigits((String)part) ? Integer.valueOf(NumberUtils.toInt((String)part)) : part;
                }
            }
        }

        @Override
        public int compareTo(Version o) {
            if (this.segments.equals(o.segments)) {
                return 0;
            }
            if (this.segments.length == 0 && o.segments.length > 0) {
                return -1;
            }
            if (this.segments.length > 0 && o.segments.length == 0) {
                return 1;
            }
            int maxLength = Math.max(this.segments.length, o.segments.length);
            for (int i = 0; i < maxLength; ++i) {
                int result;
                Object mine = null;
                Object other = null;
                if (i < this.segments.length) {
                    mine = this.segments[i];
                }
                if (i < o.segments.length) {
                    other = o.segments[i];
                }
                if (mine instanceof Integer && other == null) {
                    return 1;
                }
                if (mine instanceof String && other == null) {
                    return -1;
                }
                if (mine instanceof Integer && other instanceof String) {
                    return 1;
                }
                if (mine instanceof String && other instanceof Integer) {
                    return -1;
                }
                if (mine instanceof Integer && other instanceof Integer && (result = ((Integer)mine).compareTo((Integer)other)) != 0) {
                    return result *= -1;
                }
                if (!(mine instanceof String) || !(other instanceof String) || (result = ((String)mine).compareTo((String)other)) == 0) continue;
                return result;
            }
            return Long.compare(this.lastModified, o.lastModified) * -1;
        }
    }
}

