/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.log;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class CountingConsoleAppender
extends ConsoleAppender {
    public static final Layout DEFAULT_LAYOUT = new PatternLayout("%-5p %m%n");
    private final Map<Level, AtomicInteger> counters = new HashMap<Level, AtomicInteger>();
    private final Map<Class<?>, Logger> loggers = new HashMap();

    public CountingConsoleAppender() {
        this(DEFAULT_LAYOUT);
    }

    public CountingConsoleAppender(Layout layout, String target) {
        super(layout, target);
    }

    public CountingConsoleAppender(Layout layout) {
        super(layout);
    }

    public void append(LoggingEvent event) {
        super.append(event);
        this.getCounter(event.getLevel()).incrementAndGet();
    }

    public boolean isEmpty() {
        return this.counters.isEmpty();
    }

    public int getCount(Level level) {
        return this.getCounter(level).get();
    }

    public int getCount() {
        int count = 0;
        for (AtomicInteger i : this.counters.values()) {
            count += i.get();
        }
        return count;
    }

    public synchronized void reset() {
        super.reset();
        if (this.counters != null) {
            this.counters.clear();
        }
    }

    public synchronized void startCountingFor(Class<?> clazz, Level logLevel) {
        Logger logger = this.loggers.get(clazz);
        if (logger == null) {
            logger = LogManager.getLogger(clazz);
            this.loggers.put(clazz, logger);
        }
        if (!logger.isAttached((Appender)this)) {
            logger.addAppender((Appender)this);
        }
        logger.setLevel(logLevel);
    }

    public synchronized void stopCountingFor(Class<?> clazz) {
        Logger logger = this.loggers.get(clazz);
        if (logger != null) {
            logger.removeAppender((Appender)this);
        }
    }

    private synchronized AtomicInteger getCounter(Level level) {
        AtomicInteger i = this.counters.get(level);
        if (i == null) {
            i = new AtomicInteger();
            this.counters.put(level, i);
        }
        return i;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.counters).toString();
    }
}

