/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.map;

import com.norconex.commons.lang.map.IMapChangeListener;
import com.norconex.commons.lang.map.MapChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapChangeSupport<K, V>
implements Serializable {
    private static final long serialVersionUID = 3044416439660906663L;
    private final List<IMapChangeListener<K, V>> listeners = new ArrayList<IMapChangeListener<K, V>>();
    private final Map<K, V> source;

    public MapChangeSupport(Map<K, V> source) {
        this.source = source;
    }

    public void addMapChangeListener(IMapChangeListener<K, V> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeMapChangeListener(IMapChangeListener<K, V> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void fireMapChange(K key, V oldValue, V newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        MapChangeEvent<K, V> event = new MapChangeEvent<K, V>(this.source, key, oldValue, newValue);
        for (IMapChangeListener<K, V> l : this.listeners) {
            l.mapChanged(event);
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }
}

