/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.map;

import com.norconex.commons.lang.map.IMapChangeListener;
import com.norconex.commons.lang.map.MapChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObservableMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 8109864235479497466L;
    private final MapChangeSupport<K, V> mcs = new MapChangeSupport(this);
    private final Map<K, V> map;

    public ObservableMap() {
        this(null);
    }

    public ObservableMap(Map<K, V> map) {
        this.map = map == null ? new HashMap() : map;
    }

    public void addMapChangeListener(IMapChangeListener<K, V> listener) {
        this.mcs.addMapChangeListener(listener);
    }

    public void removeMapChangeListener(IMapChangeListener<K, V> listener) {
        this.mcs.removeMapChangeListener(listener);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.mcs.isEmpty()) {
            return this.map.put(key, value);
        }
        V oldValue = this.map.put(key, value);
        this.mcs.fireMapChange(key, oldValue, value);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        if (this.mcs.isEmpty()) {
            return this.map.remove(key);
        }
        V oldValue = this.map.remove(key);
        this.mcs.fireMapChange(key, oldValue, null);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.mcs.isEmpty()) {
            this.map.putAll(m);
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        if (this.mcs.isEmpty()) {
            this.map.clear();
            return;
        }
        HashMap<K, V> oldMap = new HashMap<K, V>(this.map);
        this.map.clear();
        for (Map.Entry entry : oldMap.entrySet()) {
            this.mcs.fireMapChange(entry.getKey(), entry.getValue(), null);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return "ObservableMap [map=" + this.map + "]";
    }
}

