/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.map;

import com.norconex.commons.lang.map.ObservableMap;
import com.norconex.commons.lang.map.PropertiesException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Properties
extends ObservableMap<String, List<String>>
implements Serializable {
    private static final long serialVersionUID = -7215126924574341L;
    private static final Logger LOG = LogManager.getLogger(Properties.class);
    @Deprecated
    public static final String DEFAULT_MULTIVALUE_DELIMITER = "^|~";
    private final boolean caseInsensitiveKeys;

    public Properties() {
        this(false);
    }

    public Properties(boolean caseInsensitiveKeys) {
        this(null, caseInsensitiveKeys);
    }

    public Properties(Map<String, List<String>> map) {
        this(map, false);
    }

    public Properties(Map<String, List<String>> map, boolean caseInsensitiveKeys) {
        super(map);
        this.caseInsensitiveKeys = caseInsensitiveKeys;
    }

    public boolean isCaseInsensitiveKeys() {
        return this.caseInsensitiveKeys;
    }

    @Deprecated
    public String getMultiValueDelimiter() {
        LOG.warn((Object)"getMultiValueDelimiter() is deprecated.");
        return null;
    }

    @Deprecated
    public void setMultiValueDelimiter(String multiValueDelimiter) {
        LOG.warn((Object)"setMultiValueDelimiter(String) is deprecated.");
    }

    public String storeToString(String comments) throws IOException {
        StringWriter writer = new StringWriter();
        this.store(writer, comments);
        String str = writer.toString();
        writer.close();
        return str;
    }

    public void store(Writer writer) throws IOException {
        this.store(writer, null);
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store(writer, comments, null);
    }

    public void store(Writer writer, String comments, String delimiter) throws IOException {
        this.store(writer, comments, null, delimiter, false);
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, null);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store(out, comments, null);
    }

    public void store(OutputStream out, String comments, String delimiter) throws IOException {
        this.store(out, comments, null, delimiter, false);
    }

    public void storeToXML(OutputStream os) throws IOException {
        this.storeToXML(os, null);
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, null);
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.storeToXML(os, comment, encoding, null);
    }

    public void storeToXML(OutputStream os, String comment, String encoding, String delimiter) throws IOException {
        this.store(os, comment, encoding, delimiter, true);
    }

    public void storeToXML(Writer writer) throws IOException {
        this.storeToXML(writer, null);
    }

    public void storeToXML(Writer writer, String comment) throws IOException {
        this.storeToXML(writer, comment, null);
    }

    public void storeToXML(Writer writer, String comment, String delimiter) throws IOException {
        this.store(writer, comment, null, delimiter, true);
    }

    private synchronized void store(Object output, String comments, String encoding, String delimiter, boolean isXML) throws IOException {
        Object p = isXML ? new XMLPropertiesConfiguration() : new PropertiesConfiguration();
        p.setDelimiterParsingDisabled(true);
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            p.setHeader(comments);
            if (StringUtils.isEmpty((CharSequence)delimiter)) {
                p.setProperty(key, (Object)values);
                continue;
            }
            p.setProperty(key, (Object)StringUtils.join((Iterable)values, (String)delimiter));
        }
        try {
            if (output instanceof Writer) {
                p.save((Writer)output);
            } else {
                p.save((OutputStream)output, StringUtils.isBlank((CharSequence)encoding) ? "UTF-8" : encoding);
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public void storeToJSON(OutputStream os) throws IOException {
        this.storeToJSON(new OutputStreamWriter(os, "UTF-8"));
    }

    public void storeToJSON(Writer writer) throws IOException {
        writer.write(123);
        boolean keyFirst = true;
        for (Map.Entry entry : this.entrySet()) {
            if (!keyFirst) {
                writer.write(44);
            }
            writer.write(34);
            writer.write(StringEscapeUtils.escapeJson((String)((String)entry.getKey())));
            writer.write("\":[");
            boolean valueFirst = true;
            for (String value : (List)entry.getValue()) {
                if (value == null) continue;
                if (!valueFirst) {
                    writer.write(44);
                }
                writer.write(34);
                writer.write(StringEscapeUtils.escapeJson((String)value));
                writer.write(34);
                valueFirst = false;
            }
            writer.write("]");
            keyFirst = false;
        }
        writer.write(125);
        writer.flush();
    }

    public void loadFromString(String str) throws IOException {
        StringReader r = new StringReader(str);
        this.load(r);
        ((Reader)r).close();
    }

    public synchronized void load(Map<?, ?> map) {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object keyObj = entry.getKey();
                if (keyObj == null) continue;
                String key = Objects.toString(keyObj, null);
                Object valObj = entry.getValue();
                if (valObj == null) {
                    valObj = "";
                }
                Iterable<Object> it = null;
                if (valObj.getClass().isArray()) {
                    it = Arrays.asList((Object[])valObj);
                } else if (valObj instanceof Iterable) {
                    it = (Iterable)valObj;
                }
                if (it == null) {
                    this.addString(key, Objects.toString(valObj, null));
                    continue;
                }
                for (Object val : it) {
                    this.addString(key, Objects.toString(val, null));
                }
            }
        }
    }

    public void load(Reader reader) throws IOException {
        this.load(reader, null);
    }

    public void load(Reader reader, String delimiter) throws IOException {
        this.load(reader, null, delimiter, false);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.load(inStream, null);
    }

    public synchronized void load(InputStream inStream, String encoding) throws IOException {
        this.load(inStream, encoding, null);
    }

    public synchronized void load(InputStream inStream, String encoding, String delimiter) throws IOException {
        this.load(inStream, encoding, delimiter, false);
    }

    public void loadFromXML(InputStream in) throws IOException {
        this.loadFromXML(in, null);
    }

    public void loadFromXML(InputStream in, String encoding) throws IOException {
        this.loadFromXML(in, encoding, null);
    }

    public void loadFromXML(InputStream in, String encoding, String delimiter) throws IOException {
        this.load(in, encoding, delimiter, true);
    }

    public void loadFromXML(Reader reader) throws IOException {
        this.loadFromXML(reader, null);
    }

    public void loadFromXML(Reader reader, String delimiter) throws IOException {
        this.load(reader, null, delimiter, true);
    }

    private synchronized void load(Object input, String encoding, String delimiter, boolean isXML) throws IOException {
        Object p = isXML ? new XMLPropertiesConfiguration() : new PropertiesConfiguration();
        p.setDelimiterParsingDisabled(true);
        try {
            if (input instanceof Reader) {
                p.load((Reader)input);
            } else {
                p.load((InputStream)input, StringUtils.isBlank((CharSequence)encoding) ? "UTF-8" : encoding);
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        Iterator it = p.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (StringUtils.isEmpty((CharSequence)delimiter)) {
                this.addString(key, p.getStringArray(key));
                continue;
            }
            this.addString(key, StringUtils.split((String)p.getString(key, ""), (String)delimiter));
        }
    }

    public void loadFromJSON(InputStream in) throws IOException {
        if (in == null) {
            return;
        }
        this.loadFromJSON(new InputStreamReader(in, "UTF-8"));
    }

    public void loadFromJSON(Reader reader) throws IOException {
        if (reader == null) {
            return;
        }
        JSONObject json = new JSONObject(new JSONTokener(reader));
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            JSONArray array = json.getJSONArray(key);
            for (int i = 0; i < array.length(); ++i) {
                String val = array.getString(i);
                this.addString(key, val);
            }
        }
    }

    public final String getString(String key) {
        Object list = this.get(key);
        if (list != null && !list.isEmpty()) {
            return (String)list.get(0);
        }
        return null;
    }

    public final String getString(String key, String defaultValue) {
        String s = this.getString(key);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public final List<String> getStrings(String key) {
        Object values = this.get(key);
        if (values == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>((Collection<String>)values);
    }

    public final void setString(String key, String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            this.remove(key);
        }
        this.put(key, (List<String>)new ArrayList<String>(Arrays.asList(values)));
    }

    public final void addString(String key, String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return;
        }
        ArrayList<String> list = this.get(key);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.addAll(Arrays.asList(values));
        this.put(key, (List<String>)list);
    }

    public final int getInt(String key) {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse integer value.", key, this.getString(key), e);
        }
    }

    public final int getInt(String key, int defaultValue) {
        String value = this.getString(key, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse integer value.", key, value, e);
        }
    }

    public final List<Integer> getInts(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Integer> ints = new ArrayList<Integer>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                ints.add(Integer.parseInt(value));
            }
            return ints;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse integer value.", key, errVal, e);
        }
    }

    public final void setInt(String key, int ... values) {
        this.setString(key, this.toStringArray(ArrayUtils.toObject((int[])values)));
    }

    public final void addInt(String key, int ... values) {
        this.addString(key, this.toStringArray(ArrayUtils.toObject((int[])values)));
    }

    public final double getDouble(String key) {
        try {
            return Double.parseDouble(this.getString(key));
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse double value.", key, this.getString(key), e);
        }
    }

    public final double getDouble(String key, double defaultValue) {
        String value = this.getString(key, Double.toString(defaultValue));
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse double value.", key, value, e);
        }
    }

    public final List<Double> getDoubles(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Double> list = new ArrayList<Double>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(Double.parseDouble(value));
            }
            return list;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse double value.", key, errVal, e);
        }
    }

    public final void setDouble(String key, double ... values) {
        this.setString(key, this.toStringArray(ArrayUtils.toObject((double[])values)));
    }

    public final void addDouble(String key, double ... values) {
        this.addString(key, this.toStringArray(ArrayUtils.toObject((double[])values)));
    }

    public final long getLong(String key) {
        try {
            return Long.parseLong(this.getString(key));
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse long value.", key, this.getString(key), e);
        }
    }

    public final long getLong(String key, long defaultValue) {
        String value = this.getString(key, Long.toString(defaultValue));
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse long value.", key, value, e);
        }
    }

    public final List<Long> getLongs(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Long> list = new ArrayList<Long>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(Long.parseLong(value));
            }
            return list;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse long value.", key, errVal, e);
        }
    }

    public final void setLong(String key, long ... values) {
        this.setString(key, this.toStringArray(ArrayUtils.toObject((long[])values)));
    }

    public final void addLong(String key, long ... values) {
        this.addString(key, this.toStringArray(ArrayUtils.toObject((long[])values)));
    }

    public final float getFloat(String key) {
        try {
            return Float.parseFloat(this.getString(key));
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse float value.", key, this.getString(key), e);
        }
    }

    public final float getFloat(String key, float defaultValue) {
        String value = this.getString(key, Float.toString(defaultValue));
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse float value.", key, value, e);
        }
    }

    public final List<Float> getFloats(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Float> list = new ArrayList<Float>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(Float.valueOf(Float.parseFloat(value)));
            }
            return list;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse float value.", key, errVal, e);
        }
    }

    public final void setFloat(String key, float ... values) {
        this.setString(key, this.toStringArray(ArrayUtils.toObject((float[])values)));
    }

    public final void addFloat(String key, float ... values) {
        this.addString(key, this.toStringArray(ArrayUtils.toObject((float[])values)));
    }

    public final BigDecimal getBigDecimal(String key) {
        String value = this.getString(key);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse BigDecimal value.", key, value, e);
        }
    }

    public final BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        BigDecimal value = this.getBigDecimal(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final List<BigDecimal> getBigDecimals(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(new BigDecimal(value));
            }
            return list;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse BigDecimal value.", key, errVal, e);
        }
    }

    public final void setBigDecimal(String key, BigDecimal ... values) {
        this.setString(key, this.toStringArray(values));
    }

    public final void addBigDecimal(String key, BigDecimal ... values) {
        this.addString(key, this.toStringArray(values));
    }

    public final Date getDate(String key) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse Date value.", key, value, e);
        }
    }

    public final Date getDate(String key, Date defaultValue) {
        Date value = this.getDate(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final List<Date> getDates(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Date> list = new ArrayList<Date>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(new Date(Long.parseLong(value)));
            }
            return list;
        }
        catch (NumberFormatException e) {
            throw this.createTypedException("Could not parse Date value.", key, errVal, e);
        }
    }

    public final void setDate(String key, Date ... values) {
        this.setString(key, this.datesToStringArray(values));
    }

    public final void addDate(String key, Date ... values) {
        this.addString(key, this.datesToStringArray(values));
    }

    private String[] datesToStringArray(Date ... values) {
        if (values == null) {
            return null;
        }
        String[] array = new String[values.length];
        for (int i = 0; i < array.length; ++i) {
            Date value = values[i];
            array[i] = value == null ? null : Long.toString(value.getTime());
        }
        return array;
    }

    public final boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, Boolean.toString(defaultValue)));
    }

    public final List<Boolean> getBooleans(String key) {
        List<String> values = this.getStrings(key);
        ArrayList<Boolean> list = new ArrayList<Boolean>(values.size());
        for (String value : values) {
            list.add(Boolean.parseBoolean(value));
        }
        return list;
    }

    public final void setBoolean(String key, boolean ... values) {
        this.setString(key, this.toStringArray(ArrayUtils.toObject((boolean[])values)));
    }

    public final void addBoolean(String key, boolean ... values) {
        this.addString(key, this.toStringArray(ArrayUtils.toObject((boolean[])values)));
    }

    public final Locale getLocale(String key) {
        try {
            return LocaleUtils.toLocale((String)this.getString(key));
        }
        catch (IllegalArgumentException e) {
            throw this.createTypedException("Could not parse Locale value.", key, this.getString(key), e);
        }
    }

    public final Locale getLocale(String key, Locale defaultValue) {
        try {
            return LocaleUtils.toLocale((String)this.getString(key));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public final List<Locale> getLocales(String key) {
        List<String> values = this.getStrings(key);
        String errVal = null;
        try {
            ArrayList<Locale> list = new ArrayList<Locale>(values.size());
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value;
                errVal = value = iterator.next();
                list.add(LocaleUtils.toLocale((String)value));
            }
            return list;
        }
        catch (IllegalArgumentException e) {
            throw this.createTypedException("Could not parse locale value.", key, errVal, e);
        }
    }

    public final void setLocale(String key, Locale ... values) {
        this.setString(key, this.toStringArray(values));
    }

    public final void addLocale(String key, Locale ... values) {
        this.addString(key, this.toStringArray(values));
    }

    public final File getFile(String key) {
        String filePath = this.getString(key);
        if (filePath == null) {
            return null;
        }
        return new File(filePath);
    }

    public final File getFile(String key, File defaultValue) {
        File value = this.getFile(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final List<File> getFiles(String key) {
        List<String> values = this.getStrings(key);
        ArrayList<File> list = new ArrayList<File>(values.size());
        for (String value : values) {
            list.add(new File(value));
        }
        return list;
    }

    public final void setFile(String key, File ... values) {
        this.setString(key, this.filesToStringArray(values));
    }

    public final void addFile(String key, File ... values) {
        this.addString(key, this.filesToStringArray(values));
    }

    private String[] filesToStringArray(File ... values) {
        if (values == null) {
            return null;
        }
        String[] array = new String[values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = values[i].getPath();
        }
        return array;
    }

    public final Class<?> getClass(String key) {
        String value = this.getString(key);
        try {
            return Class.forName(value);
        }
        catch (ClassNotFoundException e) {
            throw this.createTypedException("Could not parse class value.", key, value, e);
        }
    }

    public final Class<?> getClass(String key, Class<?> defaultValue) {
        Class<?> value = this.getClass(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public final List<Class<?>> getClasses(String key) {
        List<String> values = this.getStrings(key);
        ArrayList list = new ArrayList(values.size());
        for (String value : values) {
            list.add(this.getClass(value));
        }
        return list;
    }

    public final void setClass(String key, Class<?> ... values) {
        this.setString(key, this.classesToStringArray(values));
    }

    public final void addClass(String key, Class<?> ... values) {
        this.addString(key, this.classesToStringArray(values));
    }

    @Override
    public final List<String> get(Object key) {
        return (List)super.get(this.caseResolvedKey(key));
    }

    @Override
    public final List<String> remove(Object key) {
        return (List)super.remove(this.caseResolvedKey(key));
    }

    @Override
    public List<String> put(String key, List<String> values) {
        if (values == null) {
            return this.remove(key);
        }
        ArrayList<String> nullSafeValues = new ArrayList<String>(values.size());
        for (String value : values) {
            if (value == null) {
                nullSafeValues.add("");
                continue;
            }
            nullSafeValues.add(value);
        }
        return super.put(this.caseResolvedKey(key), nullSafeValues);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        if (!this.caseInsensitiveKeys) {
            super.putAll(m);
            return;
        }
        if (m == null) {
            return;
        }
        for (Map.Entry<? extends String, ? extends List<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values == null) continue;
            this.addString(key, values.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
    }

    private String caseResolvedKey(Object key) {
        String resolvedKey = Objects.toString(key, null);
        if (!this.isCaseInsensitiveKeys()) {
            return resolvedKey;
        }
        for (String existingKey : super.keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)existingKey, (CharSequence)resolvedKey)) continue;
            resolvedKey = existingKey;
            break;
        }
        return resolvedKey;
    }

    private String[] classesToStringArray(Class<?> ... values) {
        if (values == null) {
            return null;
        }
        String[] array = new String[values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = values[i].getName();
        }
        return array;
    }

    private PropertiesException createTypedException(String msg, String key, String value, Exception cause) {
        String message = msg + " [key=" + key + "; value=" + value + "].";
        LOG.error((Object)message, (Throwable)cause);
        return new PropertiesException(message, cause);
    }

    private String[] toStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        String[] strArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            strArray[i] = Objects.toString(array[i], "");
        }
        return strArray;
    }
}

