/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.map;

import com.norconex.commons.lang.map.Properties;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PropertyMatcher {
    private final String key;
    private final String regex;
    private final Pattern pattern;
    private final boolean caseSensitive;

    public PropertyMatcher(String key, String regex, boolean caseSensitive) {
        this.key = key;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.pattern = regex != null ? (caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2)) : Pattern.compile(".*");
    }

    public String getKey() {
        return this.key;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean matches(Properties properties) {
        if (properties == null) {
            return false;
        }
        List<String> values = properties.getStrings(this.key);
        for (String value : values) {
            if (StringUtils.isBlank((CharSequence)this.regex) && StringUtils.isBlank((CharSequence)value)) {
                return true;
            }
            String safeVal = StringUtils.trimToEmpty((String)value);
            if (!this.pattern.matcher(safeVal).matches()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.regex).append(this.caseSensitive).toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PropertyMatcher)) {
            return false;
        }
        PropertyMatcher castOther = (PropertyMatcher)other;
        return new EqualsBuilder().append((Object)this.key, (Object)castOther.key).append((Object)this.regex, (Object)castOther.regex).append(this.caseSensitive, castOther.caseSensitive).isEquals();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("key", (Object)this.key);
        builder.append("regex", (Object)this.regex);
        builder.append("caseSensitive", this.caseSensitive);
        return builder.toString();
    }
}

