/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.net;

import com.norconex.commons.lang.config.IXMLConfigurable;
import com.norconex.commons.lang.config.XMLConfigurationUtil;
import com.norconex.commons.lang.encrypt.EncryptionKey;
import com.norconex.commons.lang.encrypt.EncryptionUtil;
import com.norconex.commons.lang.encrypt.EncryptionXMLUtil;
import com.norconex.commons.lang.xml.EnhancedXMLStreamWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class ProxySettings
implements IXMLConfigurable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String proxyHost;
    private int proxyPort;
    private String proxyScheme;
    private String proxyUsername;
    private String proxyPassword;
    private EncryptionKey proxyPasswordKey;
    private String proxyRealm;

    public ProxySettings() {
    }

    public ProxySettings(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public ProxySettings setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ProxySettings setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public ProxySettings setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public ProxySettings setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public ProxySettings setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public EncryptionKey getProxyPasswordKey() {
        return this.proxyPasswordKey;
    }

    public ProxySettings setProxyPasswordKey(EncryptionKey proxyPasswordKey) {
        this.proxyPasswordKey = proxyPasswordKey;
        return this;
    }

    public String getProxyRealm() {
        return this.proxyRealm;
    }

    public ProxySettings setProxyRealm(String proxyRealm) {
        this.proxyRealm = proxyRealm;
        return this;
    }

    public boolean isSet() {
        return StringUtils.isNotBlank((CharSequence)this.proxyHost);
    }

    public void copyFrom(ProxySettings another) {
        this.proxyHost = another.proxyHost;
        this.proxyPort = another.proxyPort;
        this.proxyScheme = another.proxyScheme;
        this.proxyUsername = another.proxyUsername;
        this.proxyPassword = another.proxyPassword;
        this.proxyPasswordKey = another.proxyPasswordKey;
        this.proxyRealm = another.proxyRealm;
    }

    public HttpHost createHttpHost() {
        if (this.isSet()) {
            return new HttpHost(this.proxyHost, this.proxyPort, this.proxyScheme);
        }
        return null;
    }

    public AuthScope createAuthScope() {
        if (this.isSet()) {
            return new AuthScope(this.proxyHost, this.proxyPort, this.proxyRealm);
        }
        return null;
    }

    public Credentials createCredentials() {
        if (this.isSet() && StringUtils.isNotBlank((CharSequence)this.proxyUsername)) {
            String password = EncryptionUtil.decrypt(this.proxyPassword, this.proxyPasswordKey);
            return new UsernamePasswordCredentials(this.proxyUsername, password);
        }
        return null;
    }

    public CredentialsProvider createCredentialsProvider() {
        Credentials creds;
        if (this.isSet() && (creds = this.createCredentials()) != null) {
            BasicCredentialsProvider cp = new BasicCredentialsProvider();
            cp.setCredentials(this.createAuthScope(), creds);
            return cp;
        }
        return null;
    }

    protected String getXmlTag() {
        return "proxy";
    }

    @Override
    public void loadFromXML(Reader in) throws IOException {
        this.loadProxyFromXML(XMLConfigurationUtil.newXMLConfiguration(in));
    }

    public void loadProxyFromXML(XMLConfiguration xml) {
        this.proxyHost = xml.getString("proxyHost", this.proxyHost);
        this.proxyPort = xml.getInt("proxyPort", this.proxyPort);
        this.proxyScheme = xml.getString("proxyScheme", this.proxyScheme);
        this.proxyUsername = xml.getString("proxyUsername", this.proxyUsername);
        this.proxyPassword = xml.getString("proxyPassword", this.proxyPassword);
        this.proxyPasswordKey = EncryptionXMLUtil.loadFromXML(xml, "proxyPassword", this.proxyPasswordKey);
        this.proxyRealm = xml.getString("proxyRealm", this.proxyRealm);
    }

    @Override
    public void saveToXML(Writer out) throws IOException {
        try {
            EnhancedXMLStreamWriter writer = new EnhancedXMLStreamWriter(out);
            writer.writeStartElement(this.getXmlTag());
            writer.writeAttribute("class", this.getClass().getCanonicalName());
            writer.flush();
            this.saveProxyToXML(writer);
            writer.flush();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot save as XML.", e);
        }
    }

    public void saveProxyToXML(XMLStreamWriter out) throws IOException {
        EnhancedXMLStreamWriter writer = out instanceof EnhancedXMLStreamWriter ? (EnhancedXMLStreamWriter)out : new EnhancedXMLStreamWriter(out);
        try {
            writer.writeElementString("proxyHost", this.proxyHost);
            writer.writeElementInteger("proxyPort", this.proxyPort);
            writer.writeElementString("proxyScheme", this.proxyScheme);
            writer.writeElementString("proxyUsername", this.proxyUsername);
            writer.writeElementString("proxyPassword", this.proxyPassword);
            EncryptionXMLUtil.saveToXML(writer, "proxyPassword", this.proxyPasswordKey);
            writer.writeElementString("proxyRealm", this.proxyRealm);
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot save as XML.", e);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProxySettings)) {
            return false;
        }
        ProxySettings castOther = (ProxySettings)other;
        return new EqualsBuilder().append((Object)this.proxyHost, (Object)castOther.proxyHost).append(this.proxyPort, castOther.proxyPort).append((Object)this.proxyScheme, (Object)castOther.proxyScheme).append((Object)this.proxyUsername, (Object)castOther.proxyUsername).append((Object)this.proxyPassword, (Object)castOther.proxyPassword).append((Object)this.proxyPasswordKey, (Object)castOther.proxyPasswordKey).append((Object)this.proxyRealm, (Object)castOther.proxyRealm).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.proxyHost).append(this.proxyPort).append((Object)this.proxyScheme).append((Object)this.proxyUsername).append((Object)this.proxyPassword).append((Object)this.proxyPasswordKey).append((Object)this.proxyRealm).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("proxyHost", (Object)this.proxyHost).append("proxyPort", this.proxyPort).append("proxyScheme", (Object)this.proxyScheme).append("proxyUsername", (Object)this.proxyUsername).append("proxyPassword", (Object)this.proxyPassword).append("proxyPasswordKey", (Object)this.proxyPasswordKey).append("proxyRealm", (Object)this.proxyRealm).toString();
    }
}

