/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.pipeline;

import com.norconex.commons.lang.pipeline.IPipelineStage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Pipeline<T>
implements IPipelineStage<T> {
    private static final Logger LOG = LogManager.getLogger(Pipeline.class);
    private final List<IPipelineStage<T>> stages = new ArrayList<IPipelineStage<T>>();

    public Pipeline() {
    }

    public Pipeline(List<IPipelineStage<T>> stages) {
        this.stages.addAll(stages);
    }

    public List<IPipelineStage<T>> getStages() {
        return Collections.unmodifiableList(this.stages);
    }

    public Pipeline<T> addStages(List<IPipelineStage<T>> stages) {
        this.stages.addAll(stages);
        return this;
    }

    public Pipeline<T> addStage(IPipelineStage<T> stage) {
        this.stages.add(stage);
        return this;
    }

    public void clearStages() {
        this.stages.clear();
    }

    @Override
    public boolean execute(T context) {
        for (IPipelineStage<T> stage : this.stages) {
            if (stage.execute(context)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pipeline execution stopped at stage: " + stage));
            }
            return false;
        }
        return true;
    }
}

