/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.time;

import com.norconex.commons.lang.map.Properties;
import com.norconex.commons.lang.time.DurationParserException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DurationParser {
    private static final Logger LOG = LogManager.getLogger(DurationParser.class);
    private static final Properties UNIT_LABELS = new Properties();
    private static final Pattern PATTERN;

    public static long parse(String duration) {
        return DurationParser.parse(duration, -1L, true);
    }

    public static long parse(String duration, long defaultValue) {
        return DurationParser.parse(duration, defaultValue, false);
    }

    private static long parse(String duration, long defaultValue, boolean throwException) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            DurationParser.parseError(throwException, (Priority)Level.DEBUG, "Blank duration value.");
            return defaultValue;
        }
        if (NumberUtils.isDigits((String)duration.trim())) {
            return NumberUtils.toLong((String)duration);
        }
        if (!duration.matches(".*\\d+.*")) {
            DurationParser.parseError(throwException, (Priority)Level.ERROR, "Could not parse duration: \"" + duration + "\". No number.");
            return defaultValue;
        }
        Matcher m = PATTERN.matcher(duration);
        long ms = 0L;
        boolean matchesPattern = false;
        while (m.find()) {
            matchesPattern = true;
            String numGroup = m.group(1);
            String unitGroup = m.group(3).trim();
            String num = numGroup.replace(',', '.');
            if (!NumberUtils.isParsable((String)num)) {
                DurationParser.parseError(throwException, (Priority)Level.ERROR, "Could not parse duration: \"" + duration + "\". Invalid duration value: " + numGroup);
                return defaultValue;
            }
            float val = NumberUtils.toFloat((String)num, (float)-1.0f);
            if (val == -1.0f) {
                DurationParser.parseError(throwException, (Priority)Level.ERROR, "Could not parse duration: \"" + duration + "\". Invalid duration value: " + numGroup);
                return defaultValue;
            }
            String unitStr = unitGroup.replaceFirst("^(\\w+)(.*)", "$1");
            Unit unit = DurationParser.getUnit(unitStr);
            if (unit == null) {
                DurationParser.parseError(throwException, (Priority)Level.ERROR, "Could not parse duration: \"" + duration + "\". Unknown unit: \"" + unitStr + "\".");
                return defaultValue;
            }
            ms = (long)((double)ms + unit.ms * (double)val);
        }
        if (matchesPattern) {
            return ms;
        }
        DurationParser.parseError(throwException, (Priority)Level.ERROR, "Could not parse duration: \"" + duration + "\". Invalid duration value.");
        return defaultValue;
    }

    private static void parseError(boolean throwException, Priority logLevel, String message) {
        if (throwException) {
            throw new DurationParserException(message);
        }
        LOG.log(logLevel, (Object)message);
    }

    private static synchronized Unit getUnit(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return null;
        }
        if (label.length() == 1) {
            for (String key : UNIT_LABELS.keySet()) {
                if (!UNIT_LABELS.getString(key).equals(label)) continue;
                return Unit.valueOf(key);
            }
        } else {
            for (Map.Entry e : UNIT_LABELS.entrySet()) {
                for (String value : (List)e.getValue()) {
                    if (!value.equalsIgnoreCase(label)) continue;
                    return Unit.valueOf((String)e.getKey());
                }
            }
        }
        return null;
    }

    static {
        try {
            UNIT_LABELS.load(DurationParser.class.getResourceAsStream(ClassUtils.getShortCanonicalName(DurationParser.class) + ".properties"), null, ",");
        }
        catch (IOException e) {
            throw new DurationParserException("Coult not initialize DurationParser.", e);
        }
        PATTERN = Pattern.compile("(\\d+([\\.,]\\d+){0,1})(\\D+)");
    }

    private static enum Unit {
        millisecond(1.0),
        second(millisecond.ms() * 1000.0),
        minute(second.ms() * 60.0),
        hour(minute.ms() * 60.0),
        day(hour.ms() * 24.0),
        week(day.ms() * 7.0),
        month((float)day.ms() * 30.44f),
        year(month.ms() * 12.0);

        private double ms;

        private Unit(double ms) {
            this.ms = ms;
        }

        private double ms() {
            return this.ms;
        }
    }
}

