/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.time;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ClassUtils;

public final class DurationUtil {
    private DurationUtil() {
    }

    public static String formatShort(Locale locale, long duration) {
        return DurationUtil.format(locale, duration, false, -1);
    }

    public static String formatLong(Locale locale, long duration) {
        return DurationUtil.format(locale, duration, true, -1);
    }

    public static String formatShort(Locale locale, long duration, int maxUnits) {
        return DurationUtil.format(locale, duration, false, maxUnits);
    }

    public static String formatLong(Locale locale, long duration, int maxUnits) {
        return DurationUtil.format(locale, duration, true, maxUnits);
    }

    private static String format(Locale locale, long duration, boolean islong, int maxUnits) {
        int max = Integer.MAX_VALUE;
        if (maxUnits > 0) {
            max = maxUnits;
        }
        long days = duration / 86400000L;
        long accountedMillis = days * 86400000L;
        long hours = (duration - accountedMillis) / 3600000L;
        long mins = (duration - (accountedMillis += hours * 3600000L)) / 60000L;
        long secs = (duration - (accountedMillis += mins * 60000L)) / 1000L;
        StringBuilder b = new StringBuilder();
        int unitCount = 0;
        if (days > 0L) {
            b.append(DurationUtil.getString(locale, days, "day", islong));
            ++unitCount;
        }
        if ((hours > 0L || b.length() > 0) && unitCount < max) {
            b.append(DurationUtil.getString(locale, hours, "hour", islong));
            ++unitCount;
        }
        if ((mins > 0L || b.length() > 0) && unitCount < max) {
            b.append(DurationUtil.getString(locale, mins, "minute", islong));
            ++unitCount;
        }
        if (unitCount < max) {
            b.append(DurationUtil.getString(locale, secs, "second", islong));
        }
        return b.toString().trim();
    }

    private static String getString(Locale locale, long unitValue, String key, boolean islong) {
        String k = key;
        if (islong && unitValue > 1L) {
            k = k + "s";
        }
        String pkg = ClassUtils.getPackageName(DurationUtil.class);
        ResourceBundle time = locale != null && Locale.FRENCH.getLanguage().equals(locale.getLanguage()) ? ResourceBundle.getBundle(pkg + ".time", Locale.FRENCH) : ResourceBundle.getBundle(pkg + ".time");
        if (islong) {
            return " " + unitValue + " " + time.getString("timeunit.long." + k);
        }
        return unitValue + time.getString("timeunit.short." + k);
    }
}

