/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public final class YearMonthDay
implements Comparable<YearMonthDay>,
Serializable {
    private static final long serialVersionUID = -2844519358776099395L;
    private final int year;
    private final int month;
    private final int day;

    public YearMonthDay() {
        this(Calendar.getInstance());
    }

    public YearMonthDay(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public YearMonthDay(int year, int month) {
        this(year, month, 1);
    }

    public YearMonthDay(int year) {
        this(year, 1, 1);
    }

    public YearMonthDay(Date date) {
        this(DateUtils.toCalendar((Date)date));
    }

    public YearMonthDay(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public YearMonthDay(String date) {
        this(Integer.valueOf(StringUtils.substringBefore((String)date, (String)"-")), Integer.valueOf(StringUtils.substringBetween((String)date, (String)"-")), Integer.valueOf(StringUtils.substringAfterLast((String)date, (String)"-")));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public boolean isBefore(YearMonthDay ymd) {
        return this.compareTo(ymd) < 0;
    }

    public boolean isBeforeDate(Date date) {
        return this.isBefore(new YearMonthDay(date));
    }

    public boolean isAfter(YearMonthDay ymd) {
        return this.compareTo(ymd) > 0;
    }

    public boolean isAfterDate(Date date) {
        return this.isAfter(new YearMonthDay(date));
    }

    public boolean contains(Date date) {
        return this.equals(new YearMonthDay(date));
    }

    public Date toDate() {
        return this.toCalendar().getTime();
    }

    public long toMillis() {
        return this.toCalendar().getTimeInMillis();
    }

    public Date toEndOfDayDate() {
        Calendar cal = this.toCalendar();
        cal.add(5, 1);
        return cal.getTime();
    }

    public YearMonthDay addDays(int numOfDays) {
        Calendar cal = this.toCalendar();
        cal.add(5, numOfDays);
        return new YearMonthDay(cal.getTime());
    }

    public YearMonthDay addMonths(int numOfMonths) {
        Calendar cal = this.toCalendar();
        cal.add(2, numOfMonths);
        return new YearMonthDay(cal.getTime());
    }

    public YearMonthDay addYears(int numOfYears) {
        Calendar cal = this.toCalendar();
        cal.add(1, numOfYears);
        return new YearMonthDay(cal.getTime());
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(this.year, this.month - 1, this.day);
        cal = DateUtils.truncate((Calendar)cal, (int)5);
        return cal;
    }

    @Override
    public int compareTo(YearMonthDay ymd) {
        if (ymd == null) {
            return -1;
        }
        int val = Integer.valueOf(this.year).compareTo(ymd.year);
        if (val == 0) {
            val = Integer.valueOf(this.month).compareTo(ymd.month);
        }
        if (val == 0) {
            val = Integer.valueOf(this.day).compareTo(ymd.day);
        }
        return val;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YearMonthDay other = (YearMonthDay)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    public String toString() {
        return "" + this.year + '-' + StringUtils.leftPad((String)Integer.toString(this.month), (int)2, (char)'0') + '-' + StringUtils.leftPad((String)Integer.toString(this.day), (int)2, (char)'0');
    }

    public String toString(String pattern) {
        return DateFormatUtils.formatUTC((Date)this.toDate(), (String)pattern);
    }
}

