/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.time;

import com.norconex.commons.lang.time.YearMonthDay;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public final class YearMonthDayInterval
implements Serializable {
    private static final long serialVersionUID = -5607689446876900272L;
    private final YearMonthDay start;
    private final YearMonthDay end;

    public YearMonthDayInterval(YearMonthDay start, YearMonthDay end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("YearMonthday start and YearMonthday end cannot be null.");
        }
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("YearMonthDay start cannot be after YearMonthDay end.");
        }
        this.start = start;
        this.end = end;
    }

    public YearMonthDayInterval(String interval) {
        String trimmed = StringUtils.trim((String)interval);
        String startStr = StringUtils.substringBefore((String)trimmed, (String)" ");
        String endStr = StringUtils.substringAfterLast((String)trimmed, (String)" ");
        if (StringUtils.isBlank((CharSequence)startStr) || StringUtils.isBlank((CharSequence)endStr)) {
            throw new IllegalArgumentException("String YearMonthDay interval cannot be null or empty.");
        }
        this.start = new YearMonthDay(startStr);
        this.end = new YearMonthDay(endStr);
    }

    public YearMonthDayInterval(Date start, Date end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Date start and Date end cannot be null.");
        }
        this.start = new YearMonthDay(start);
        this.end = new YearMonthDay(end);
    }

    public YearMonthDayInterval(Calendar start, Calendar end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Calendar start and Calendar end cannot be null.");
        }
        this.start = new YearMonthDay(start);
        this.end = new YearMonthDay(end);
    }

    public YearMonthDay getStart() {
        return this.start;
    }

    public Date getStartDate() {
        return this.start.toDate();
    }

    public YearMonthDay getEnd() {
        return this.end;
    }

    public Date getEndDate() {
        return this.end.toDate();
    }

    public Date getEndDateEndOfDay() {
        return this.end.toEndOfDayDate();
    }

    public boolean contains(YearMonthDay ymd) {
        if (this.start.isAfter(ymd)) {
            return false;
        }
        return !this.end.isBefore(ymd);
    }

    public boolean contains(Date date) {
        Date startDate = this.start.toDate();
        Date endDate = this.end.toDate();
        if (startDate.after(date)) {
            return false;
        }
        return !endDate.before(date);
    }

    public int getYears() {
        int years = this.end.getYear() - this.start.getYear();
        if (this.end.getMonth() < this.start.getMonth()) {
            return years - 1;
        }
        if (this.end.getMonth() == this.start.getMonth() && this.end.getDay() < this.start.getDay()) {
            return years - 1;
        }
        return years;
    }

    public int getMonths() {
        int months = 0;
        Calendar cal = this.start.toCalendar();
        Calendar endCal = this.end.toCalendar();
        cal.add(2, 1);
        while (!cal.after(endCal)) {
            ++months;
            cal.add(2, 1);
        }
        return months;
    }

    public int getDays() {
        return (int)((this.end.toMillis() - this.start.toMillis()) / 86400000L);
    }

    public String toString() {
        return this.start + " - " + this.end;
    }
}

