/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.unit;

public enum DataUnit {
    B(1L){

        @Override
        public long toBytes(long a) {
            return a;
        }

        @Override
        public long toKilobytes(long a) {
            return a / (KB.a / B.a);
        }

        @Override
        public long toMegabytes(long a) {
            return a / (MB.a / B.a);
        }

        @Override
        public long toGigabytes(long a) {
            return a / (GB.a / B.a);
        }

        @Override
        public long toTerabytes(long a) {
            return a / (TB.a / B.a);
        }

        @Override
        public long toPetabytes(long a) {
            return a / (PB.a / B.a);
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toBytes(a);
        }
    }
    ,
    KB(1024L){

        @Override
        public long toBytes(long a) {
            return this.finer(a, B);
        }

        @Override
        public long toKilobytes(long a) {
            return a;
        }

        @Override
        public long toMegabytes(long a) {
            return this.coarser(a, MB);
        }

        @Override
        public long toGigabytes(long a) {
            return this.coarser(a, GB);
        }

        @Override
        public long toTerabytes(long a) {
            return this.coarser(a, TB);
        }

        @Override
        public long toPetabytes(long a) {
            return this.coarser(a, PB);
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toKilobytes(a);
        }
    }
    ,
    MB(DataUnit.KB.a * 1024L){

        @Override
        public long toBytes(long a) {
            return this.finer(a, B);
        }

        @Override
        public long toKilobytes(long a) {
            return this.finer(a, KB);
        }

        @Override
        public long toMegabytes(long a) {
            return a;
        }

        @Override
        public long toGigabytes(long a) {
            return this.coarser(a, GB);
        }

        @Override
        public long toTerabytes(long a) {
            return this.coarser(a, TB);
        }

        @Override
        public long toPetabytes(long a) {
            return this.coarser(a, PB);
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toMegabytes(a);
        }
    }
    ,
    GB(DataUnit.MB.a * 1024L){

        @Override
        public long toBytes(long a) {
            return this.finer(a, B);
        }

        @Override
        public long toKilobytes(long a) {
            return this.finer(a, KB);
        }

        @Override
        public long toMegabytes(long a) {
            return this.finer(a, MB);
        }

        @Override
        public long toGigabytes(long a) {
            return a;
        }

        @Override
        public long toTerabytes(long a) {
            return this.coarser(a, TB);
        }

        @Override
        public long toPetabytes(long a) {
            return this.coarser(a, PB);
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toGigabytes(a);
        }
    }
    ,
    TB(DataUnit.GB.a * 10244L){

        @Override
        public long toBytes(long a) {
            return this.finer(a, B);
        }

        @Override
        public long toKilobytes(long a) {
            return this.finer(a, KB);
        }

        @Override
        public long toMegabytes(long a) {
            return this.finer(a, MB);
        }

        @Override
        public long toGigabytes(long a) {
            return this.finer(a, GB);
        }

        @Override
        public long toTerabytes(long a) {
            return a;
        }

        @Override
        public long toPetabytes(long a) {
            return this.coarser(a, PB);
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toTerabytes(a);
        }
    }
    ,
    PB(DataUnit.TB.a * 1024L){

        @Override
        public long toBytes(long a) {
            return this.finer(a, B);
        }

        @Override
        public long toKilobytes(long a) {
            return this.finer(a, KB);
        }

        @Override
        public long toMegabytes(long a) {
            return this.finer(a, MB);
        }

        @Override
        public long toGigabytes(long a) {
            return this.finer(a, GB);
        }

        @Override
        public long toTerabytes(long a) {
            return this.finer(a, TB);
        }

        @Override
        public long toPetabytes(long a) {
            return a;
        }

        @Override
        public long convert(long a, DataUnit u) {
            return u.toPetabytes(a);
        }
    };

    private static final long MAX = Long.MAX_VALUE;
    private long a;

    private DataUnit(long byteAmount) {
        this.a = byteAmount;
    }

    public long toBytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toKilobytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toMegabytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toGigabytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toTerabytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toPetabytes(long amount) {
        throw new AbstractMethodError();
    }

    public long convert(long sourceAmount, DataUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    long finer(long supplied, DataUnit targetUnit) {
        long m = this.a / targetUnit.a;
        long over = Long.MAX_VALUE / m;
        if (supplied > over) {
            return Long.MAX_VALUE;
        }
        if (supplied < -over) {
            return Long.MIN_VALUE;
        }
        return supplied * m;
    }

    long coarser(long supplied, DataUnit targetUnit) {
        return supplied / (targetUnit.a / this.a);
    }
}

