/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.unit;

import com.norconex.commons.lang.unit.DataUnit;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataUnitFormatter
implements Serializable {
    private static final long serialVersionUID = -8672773710734223185L;
    private static final DataUnit[] DATA_UNITS = DataUnit.values();
    private static final int K = 1024;
    private static final int D = 10;
    private final Locale locale;
    private final int decimalPrecision;
    private final boolean fixedUnit;
    private transient int hashCode;

    public DataUnitFormatter() {
        this(null);
    }

    public DataUnitFormatter(Locale locale) {
        this(locale, 0);
    }

    public DataUnitFormatter(int decimalPrecision) {
        this(null, decimalPrecision);
    }

    public DataUnitFormatter(Locale locale, int decimalPrecision) {
        this(locale, decimalPrecision, false);
    }

    public DataUnitFormatter(Locale locale, int decimalPrecision, boolean fixedUnit) {
        this.locale = locale;
        this.decimalPrecision = decimalPrecision;
        this.fixedUnit = fixedUnit;
    }

    public String format(long amount, DataUnit unit) {
        Locale finalLocale;
        int previousOrdinal;
        int ordinalShift;
        if (unit == null) {
            return Long.toString(amount);
        }
        DataUnit finalUnit = unit;
        long finalAmount = amount;
        if (!this.fixedUnit && (ordinalShift = (int)(Math.log(amount) / Math.log(1024.0))) > 0) {
            finalUnit = DATA_UNITS[Math.min(unit.ordinal() + ordinalShift, DATA_UNITS.length - 1)];
            finalAmount = finalUnit.convert(amount, unit);
        }
        long decimals = 0L;
        if (this.decimalPrecision > 0 && unit.ordinal() < finalUnit.ordinal() && (previousOrdinal = finalUnit.ordinal() - 1) >= 0) {
            long originalBytes = unit.toBytes(amount);
            long finalBytes = finalUnit.toBytes(finalAmount);
            long diff = originalBytes - finalBytes;
            DataUnit previousUnit = DATA_UNITS[previousOrdinal];
            long remainder = previousUnit.convert(diff, DataUnit.B);
            long base = remainder * (long)Math.pow(10.0, this.decimalPrecision);
            decimals = base / 1024L;
        }
        if ((finalLocale = this.locale) == null) {
            finalLocale = Locale.getDefault();
        }
        StringBuilder b = new StringBuilder();
        b.append(NumberFormat.getIntegerInstance(finalLocale).format(finalAmount));
        if (decimals > 0L) {
            b.append(DecimalFormatSymbols.getInstance(finalLocale).getDecimalSeparator());
            b.append(StringUtils.left((String)Long.toString(decimals), (int)this.decimalPrecision));
        }
        b.append('\u00a0').append(finalUnit.toString());
        return b.toString();
    }

    public String toString() {
        return "DataUnitFormatter [locale=" + this.locale + ", decimalPrecision=" + this.decimalPrecision + ", fixedUnit=" + this.fixedUnit + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataUnitFormatter)) {
            return false;
        }
        DataUnitFormatter castOther = (DataUnitFormatter)other;
        return new EqualsBuilder().append((Object)this.locale, (Object)castOther.locale).append(this.decimalPrecision, castOther.decimalPrecision).append(this.fixedUnit, castOther.fixedUnit).isEquals();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = new HashCodeBuilder().append((Object)this.locale).append(this.decimalPrecision).append(this.fixedUnit).toHashCode();
        }
        return this.hashCode;
    }
}

