/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.url;

import com.norconex.commons.lang.map.Properties;
import com.norconex.commons.lang.url.URLException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;

public class QueryString
extends Properties {
    private static final long serialVersionUID = 1744232652147275170L;
    private final String encoding;

    public QueryString() {
        this("", StandardCharsets.UTF_8.toString());
    }

    public QueryString(URL urlWithQueryString) {
        this(urlWithQueryString.toString(), null);
    }

    public QueryString(URL urlWithQueryString, String encoding) {
        this(urlWithQueryString.toString(), encoding);
    }

    public QueryString(String urlWithQueryString) {
        this(urlWithQueryString, null);
    }

    public QueryString(String urlWithQueryString, String encoding) {
        super((Map<String, List<String>>)new ListOrderedMap());
        this.encoding = StringUtils.isBlank((CharSequence)encoding) ? StandardCharsets.UTF_8.toString() : encoding;
        String paramString = urlWithQueryString;
        if (StringUtils.contains((CharSequence)paramString, (CharSequence)"?")) {
            paramString = StringUtils.substringBefore((String)paramString, (String)"#");
            paramString = paramString.replaceAll("(.*?)(\\?)(.*)", "$3");
        }
        String[] paramParts = paramString.split("\\&");
        for (int i = 0; i < paramParts.length; ++i) {
            String value;
            String key;
            String paramPart = paramParts[i];
            if (StringUtils.isBlank((CharSequence)paramPart)) continue;
            if (StringUtils.contains((CharSequence)paramPart, (CharSequence)"=")) {
                key = StringUtils.substringBefore((String)paramPart, (String)"=");
                value = StringUtils.substringAfter((String)paramPart, (String)"=");
            } else {
                key = paramPart;
                value = "";
            }
            try {
                this.addString(URLDecoder.decode(key, this.encoding), URLDecoder.decode(value, this.encoding));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new URLException("Cannot URL-decode query string (key=" + key + "; value=" + value + ").", e);
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public synchronized String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int sep = 63;
        for (String key : this.keySet()) {
            for (String value : this.getStrings(key)) {
                b.append((char)sep);
                sep = 38;
                try {
                    b.append(URLEncoder.encode(key, this.encoding));
                    b.append('=');
                    b.append(URLEncoder.encode(value, this.encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new URLException("Cannot URL-encode query string (key=" + key + "; value=" + value + ").", e);
                }
            }
        }
        return b.toString();
    }

    public String applyOnURL(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        return StringUtils.substringBefore((String)url, (String)"?") + this.toString();
    }

    public URL applyOnURL(URL url) {
        if (url == null) {
            return url;
        }
        try {
            return new URL(this.applyOnURL(url.toString()));
        }
        catch (MalformedURLException e) {
            throw new URLException("Cannot applyl query string to: " + url, e);
        }
    }
}

