/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.url;

import com.norconex.commons.lang.url.HttpURL;
import com.norconex.commons.lang.url.URLException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class URLStreamer {
    private static final Logger LOG = LogManager.getLogger(URLStreamer.class);

    private URLStreamer() {
    }

    public static InputStream stream(String url) {
        return URLStreamer.stream(url, null);
    }

    public static InputStream stream(URL url) {
        return URLStreamer.stream(url.toString(), null);
    }

    public static InputStream stream(HttpURL url) {
        return URLStreamer.stream(url.toString(), null);
    }

    public static InputStream stream(String url, Credentials creds) {
        return URLStreamer.stream(url, creds, null);
    }

    public static InputStream stream(URL url, Credentials creds) {
        return URLStreamer.stream(url.toString(), creds, null);
    }

    public static InputStream stream(HttpURL url, Credentials creds) {
        return URLStreamer.stream(url.toString(), creds, null);
    }

    public static InputStream stream(String url, Credentials creds, HttpHost proxy) {
        return URLStreamer.stream(url, creds, proxy, null);
    }

    public static InputStream stream(URL url, Credentials creds, HttpHost proxy) {
        return URLStreamer.stream(url.toString(), creds, proxy, null);
    }

    public static InputStream stream(HttpURL url, Credentials creds, HttpHost proxy) {
        return URLStreamer.stream(url.toString(), creds, proxy, null);
    }

    public static InputStream stream(String url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        try {
            URLConnection conn;
            if (proxy != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Streaming with proxy: " + proxy.getHostName() + ":" + proxy.getPort()));
                }
                Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHostName(), proxy.getPort()));
                conn = new URL(url).openConnection(p);
                if (proxyCreds != null) {
                    LOG.debug((Object)"Streaming with proxy credentials.");
                    conn.setRequestProperty("Proxy-Authorization", URLStreamer.base64BasicAuth(proxyCreds.getUsername(), proxyCreds.getPassword()));
                }
            } else {
                conn = new URL(url).openConnection();
            }
            if (creds != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Streaming with credentials.");
                }
                conn.setRequestProperty("Authorization", URLStreamer.base64BasicAuth(creds.getUsername(), creds.getPassword()));
            }
            return URLStreamer.responseInputStream(conn);
        }
        catch (IOException e) {
            throw new URLException("Could not stream URL: " + url, e);
        }
    }

    public static InputStream stream(URL url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        return URLStreamer.stream(url.toString(), creds, proxy, proxyCreds);
    }

    public static InputStream stream(HttpURL url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        return URLStreamer.stream(url.toString(), creds, proxy, proxyCreds);
    }

    public static String streamToString(String url, Credentials creds, HttpHost proxy) {
        return URLStreamer.streamToString(url, creds, proxy, StandardCharsets.UTF_8.toString());
    }

    public static String streamToString(String url, Credentials creds, HttpHost proxy, String charEncoding) {
        String out;
        StopWatch watch = null;
        if (LOG.isDebugEnabled()) {
            watch = new StopWatch();
            watch.start();
            LOG.debug((Object)("Streaming URL:" + url));
        }
        try {
            out = IOUtils.toString((InputStream)URLStreamer.stream(url, creds, proxy), (String)charEncoding);
        }
        catch (IOException e) {
            throw new URLException("Could not stream URL to string: " + url, e);
        }
        if (LOG.isDebugEnabled() && watch != null) {
            watch.stop();
            LOG.debug((Object)("Streaming elapsed time: " + watch.toString()));
        }
        return out;
    }

    public static String streamToString(URL url, Credentials creds, HttpHost proxy) {
        return URLStreamer.streamToString(url.toString(), creds, proxy);
    }

    public static String streamToString(HttpURL url, Credentials creds, HttpHost proxy) {
        return URLStreamer.streamToString(url.toString(), creds, proxy);
    }

    public static String streamToString(String url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        return URLStreamer.streamToString(url, creds, proxy, proxyCreds, StandardCharsets.UTF_8.toString());
    }

    public static String streamToString(String url, Credentials creds, HttpHost proxy, Credentials proxyCreds, String charEncoding) {
        String out;
        StopWatch watch = null;
        if (LOG.isDebugEnabled()) {
            watch = new StopWatch();
            watch.start();
            LOG.debug((Object)("Streaming URL:" + url));
        }
        try {
            out = IOUtils.toString((InputStream)URLStreamer.stream(url, creds, proxy, proxyCreds), (String)charEncoding);
        }
        catch (IOException e) {
            throw new URLException("Could not stream URL to string: " + url, e);
        }
        if (LOG.isDebugEnabled() && watch != null) {
            watch.stop();
            LOG.debug((Object)("Streaming elapsed time: " + watch.toString()));
        }
        return out;
    }

    public static String streamToString(URL url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        return URLStreamer.streamToString(url.toString(), creds, proxy, proxyCreds);
    }

    public static String streamToString(HttpURL url, Credentials creds, HttpHost proxy, Credentials proxyCreds) {
        return URLStreamer.streamToString(url.toString(), creds, proxy, proxyCreds);
    }

    public static String streamToString(String url, Credentials creds) {
        return URLStreamer.streamToString(url, creds, null);
    }

    public static String streamToString(URL url, Credentials creds) {
        return URLStreamer.streamToString(url.toString(), creds, null);
    }

    public static String streamToString(HttpURL url, Credentials creds) {
        return URLStreamer.streamToString(url.toString(), creds, null);
    }

    public static String streamToString(String url) {
        return URLStreamer.streamToString(url, null);
    }

    public static String streamToString(URL url) {
        return URLStreamer.streamToString(url, null);
    }

    public static String streamToString(HttpURL url) {
        return URLStreamer.streamToString(url.toString(), null);
    }

    private static InputStream responseInputStream(URLConnection conn) throws IOException {
        conn.connect();
        return new AutoCloseInputStream(conn.getInputStream());
    }

    private static String base64BasicAuth(String username, String password) {
        String userpass = username + ':' + password;
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
    }

    public static class HttpHost {
        private final String hostName;
        private final int port;

        public HttpHost(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

