/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.xml;

import com.norconex.commons.lang.xml.ClasspathInput;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ClasspathResourceResolver
implements LSResourceResolver {
    private static final Logger LOG = LogManager.getLogger(ClasspathResourceResolver.class);
    private final String rootPath;

    public ClasspathResourceResolver() {
        this((String)null);
    }

    public ClasspathResourceResolver(Class<?> relativeTo) {
        this(ClasspathResourceResolver.getPackageResourcePathFromClass(relativeTo));
    }

    public ClasspathResourceResolver(String relativeTo) {
        this.rootPath = relativeTo;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String path = this.rootPath;
        if (baseURI != null) {
            path = this.getPackageResourcePathFromBaseURI(baseURI);
        }
        String r = this.getResourcePath(path, systemId);
        InputStream resourceAsStream = this.getClass().getResourceAsStream(r);
        if (resourceAsStream == null) {
            LOG.error((Object)("Resource not found: " + r + " (baseURI: " + baseURI + "; systemId: " + systemId));
        }
        return new ClasspathInput(publicId, r, resourceAsStream);
    }

    private String getResourcePath(String path, String systemId) {
        if (systemId.startsWith("/")) {
            return systemId;
        }
        int upCount = StringUtils.countMatches((CharSequence)systemId, (CharSequence)"../");
        String newPath = path;
        for (int i = 0; i < upCount; ++i) {
            newPath = newPath.replaceFirst("(.*/)(.*/)$", "$1");
        }
        return newPath + systemId.replaceFirst("^(../)+", "");
    }

    private static String getPackageResourcePathFromClass(Class<?> klass) {
        if (klass == null) {
            return "";
        }
        return "/" + klass.getPackage().getName().replace('.', '/') + "/";
    }

    private String getPackageResourcePathFromBaseURI(String baseURI) {
        if (baseURI == null) {
            return "";
        }
        return baseURI.replaceFirst("^(file://)*(.*/).*", "$2");
    }
}

