/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.xml;

import java.awt.Dimension;
import java.io.Writer;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EnhancedXMLStreamWriter
implements XMLStreamWriter {
    private static final Logger LOG = LogManager.getLogger(EnhancedXMLStreamWriter.class);
    private final XMLStreamWriter writer;
    private final boolean defaultWriteBlanks;
    private final int indent;
    private int depth = 0;
    private boolean indentEnd = false;

    public EnhancedXMLStreamWriter(Writer out) throws XMLStreamException {
        this(out, false);
    }

    public EnhancedXMLStreamWriter(Writer out, boolean writeBlanks) throws XMLStreamException {
        this(out, writeBlanks, -1);
    }

    public EnhancedXMLStreamWriter(Writer out, boolean writeBlanks, int indent) throws XMLStreamException {
        XMLOutputFactory factory = EnhancedXMLStreamWriter.createXMLOutputFactory();
        this.writer = factory.createXMLStreamWriter(out);
        this.defaultWriteBlanks = writeBlanks;
        this.indent = indent;
    }

    public EnhancedXMLStreamWriter(XMLStreamWriter xmlStreamWriter) {
        this(xmlStreamWriter, false);
    }

    public EnhancedXMLStreamWriter(XMLStreamWriter xmlStreamWriter, boolean writeBlanks) {
        this(xmlStreamWriter, writeBlanks, -1);
    }

    public EnhancedXMLStreamWriter(XMLStreamWriter xmlStreamWriter, boolean writeBlanks, int indent) {
        this.writer = xmlStreamWriter;
        this.defaultWriteBlanks = writeBlanks;
        this.indent = indent;
    }

    private void indent() throws XMLStreamException {
        this.indentEnd = true;
        if (this.indent > -1) {
            this.writer.writeCharacters("\n");
            if (this.indent > 0) {
                this.writer.writeCharacters(StringUtils.repeat((char)' ', (int)(this.depth * this.indent)));
            }
        }
    }

    private static XMLOutputFactory createXMLOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        if ("com.ctc.wstx.stax.WstxOutputFactory".equals(factory.getClass().getName())) {
            try {
                Object config = factory.getClass().getMethod("getConfig", new Class[0]).invoke((Object)factory, new Object[0]);
                config.getClass().getMethod("doValidateStructure", Boolean.TYPE).invoke(config, false);
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not disable structure validation on WstxOutputFactory. This can cause issues when using EnhancedXMLStreamWriter on an partially written XML stream (\"multiple roots\" error).");
            }
        }
        return factory;
    }

    public void writeAttributeInteger(String localName, Integer value) throws XMLStreamException {
        this.writeAttributeInteger(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeInteger(String localName, Integer value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeLong(String localName, Long value) throws XMLStreamException {
        this.writeAttributeLong(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeLong(String localName, Long value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeFloat(String localName, Float value) throws XMLStreamException {
        this.writeAttributeFloat(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeFloat(String localName, Float value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeDouble(String localName, Double value) throws XMLStreamException {
        this.writeAttributeDouble(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeDouble(String localName, Double value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeBoolean(String localName, Boolean value) throws XMLStreamException {
        this.writeAttributeBoolean(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeBoolean(String localName, Boolean value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeString(String localName, String value) throws XMLStreamException {
        this.writeAttributeString(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeString(String localName, String value, boolean writeBlanks) throws XMLStreamException {
        this.writeAttributeObject(localName, value, writeBlanks);
    }

    public void writeAttributeClass(String localName, Class<?> value) throws XMLStreamException {
        this.writeAttributeClass(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeClass(String localName, Class<?> value, boolean writeBlanks) throws XMLStreamException {
        if (value == null) {
            this.writeAttributeObject(localName, null, writeBlanks);
        } else {
            this.writeAttributeObject(localName, value.getCanonicalName(), writeBlanks);
        }
    }

    public void writeAttributeObject(String localName, Object value) throws XMLStreamException {
        this.writeAttributeObject(localName, value, this.defaultWriteBlanks);
    }

    public void writeAttributeObject(String localName, Object value, boolean writeBlanks) throws XMLStreamException {
        String strValue = Objects.toString(value, null);
        if (StringUtils.isNotBlank((CharSequence)strValue)) {
            this.writeAttribute(localName, strValue);
        } else if (writeBlanks) {
            this.writeAttribute(localName, "");
        }
    }

    public void writeElementInteger(String localName, Integer value) throws XMLStreamException {
        this.writeElementInteger(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementInteger(String localName, Integer value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementLong(String localName, Long value) throws XMLStreamException {
        this.writeElementLong(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementLong(String localName, Long value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementFloat(String localName, Float value) throws XMLStreamException {
        this.writeElementFloat(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementFloat(String localName, Float value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementDouble(String localName, Double value) throws XMLStreamException {
        this.writeElementDouble(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementDouble(String localName, Double value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementBoolean(String localName, Boolean value) throws XMLStreamException {
        this.writeElementBoolean(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementBoolean(String localName, Boolean value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementString(String localName, String value) throws XMLStreamException {
        this.writeElementString(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementString(String localName, String value, boolean writeBlanks) throws XMLStreamException {
        this.writeElementObject(localName, value, writeBlanks);
    }

    public void writeElementClass(String localName, Class<?> value) throws XMLStreamException {
        this.writeElementClass(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementClass(String localName, Class<?> value, boolean writeBlanks) throws XMLStreamException {
        if (value == null) {
            this.writeElementObject(localName, null, writeBlanks);
        } else {
            this.writeElementObject(localName, value.getCanonicalName(), writeBlanks);
        }
    }

    public void writeElementDimension(String localName, Dimension value) throws XMLStreamException {
        this.writeElementDimension(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementDimension(String localName, Dimension value, boolean writeBlanks) throws XMLStreamException {
        if (value == null) {
            this.writeElementObject(localName, null, writeBlanks);
        } else {
            String str = value.getWidth() == value.getHeight() ? Integer.toString((int)value.getWidth()) : Integer.toString((int)value.getWidth()) + "x" + Integer.toString((int)value.getHeight());
            this.writeElementObject(localName, str, writeBlanks);
        }
    }

    public void writeElementObject(String localName, Object value) throws XMLStreamException {
        this.writeElementObject(localName, value, this.defaultWriteBlanks);
    }

    public void writeElementObject(String localName, Object value, boolean writeBlanks) throws XMLStreamException {
        String strValue = Objects.toString(value, null);
        if (StringUtils.isNotBlank((CharSequence)strValue)) {
            this.writeStartElement(localName);
            this.writeCharacters(strValue);
            this.writeEndElement();
        } else if (writeBlanks) {
            this.writeEmptyElement(localName);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.indent();
        ++this.depth;
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.indent();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.indent();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.indent();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.indentEnd) {
            this.indent();
        }
        this.indentEnd = true;
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(namespaceURI, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.indent();
        this.writer.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.indent();
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.indent();
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.indent();
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (this.indent < 0) {
            this.writer.writeCharacters(text);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String[] lines = text.split("\n");
            if (lines.length == 1) {
                this.writer.writeCharacters(lines[0]);
                this.indentEnd = false;
            } else {
                for (String line : lines) {
                    this.indent();
                    this.writer.writeCharacters(line);
                }
            }
        } else {
            this.indentEnd = false;
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) {
        return this.writer.getProperty(name);
    }
}

