/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ListErrorHandler
implements ErrorHandler {
    private final List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private final List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private final List<SAXParseException> fatalErrors = new ArrayList<SAXParseException>();

    @Override
    public void error(SAXParseException exception) {
        this.errors.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.fatalErrors.add(exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        this.warnings.add(exception);
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<String> getErrorMessages() {
        return this.getMessages(this.errors);
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    public List<String> getFatalErrorMessages() {
        return this.getMessages(this.fatalErrors);
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public List<String> getWarningMessages() {
        return this.getMessages(this.warnings);
    }

    public List<SAXParseException> getAll() {
        ArrayList<SAXParseException> all = new ArrayList<SAXParseException>();
        all.addAll(this.fatalErrors);
        all.addAll(this.errors);
        all.addAll(this.warnings);
        return all;
    }

    public List<String> getAllMessages() {
        return this.getMessages(this.getAll());
    }

    public boolean isEmpty() {
        return this.errors.isEmpty() && this.fatalErrors.isEmpty() && this.warnings.isEmpty();
    }

    public int size() {
        return this.errors.size() + this.fatalErrors.size() + this.warnings.size();
    }

    private List<String> getMessages(List<SAXParseException> exceptions) {
        ArrayList<String> msgs = new ArrayList<String>();
        for (SAXParseException e : exceptions) {
            msgs.add(e.getLocalizedMessage());
        }
        return msgs;
    }
}

