/*
 * Decompiled with CFR 0.152.
 */
package com.nordea.oss.copybook.codegen;

import com.nordea.oss.ByteUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class CopyBookConverter {
    private final ScriptEngineManager manager;
    private ScriptEngine engine;
    private final Invocable invocable;
    static Pattern re_className = Pattern.compile("^.*?\\s(?:class|@interface|enum)\\s*([^\\s]+)", 32);

    public CopyBookConverter() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("classconverter.html");
        String js = this.extractJS(inputStream);
        this.manager = new ScriptEngineManager();
        this.engine = this.manager.getEngineByName("nashorn");
        if (this.engine == null) {
            throw new Exception("Could not load the Nashorn script engine");
        }
        this.invocable = (Invocable)((Object)this.engine);
        this.engine.eval(js);
    }

    public void convertFiles(String inputPath, Pattern pattern, String outputPath, String packageRootName, String accessor, String charset, String subClassHandling) throws Exception {
        File inputFile = new File(inputPath);
        inputPath = inputFile.getCanonicalPath();
        List<File> inputFiles = new ArrayList<File>();
        if (inputFile.isDirectory()) {
            inputFiles = Files.walk(inputFile.toPath(), new FileVisitOption[0]).filter(p -> pattern.matcher(p.toString()).find() && Files.isRegularFile(p, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        } else if (inputFile.isFile()) {
            inputFiles.add(inputFile);
        }
        for (File inFile : inputFiles) {
            String packageName = inFile.getCanonicalFile().getParent().substring(inputPath.length()).replace('\\', '.').replace('/', '.').replace('_', '.');
            packageName = packageName.isEmpty() ? packageRootName : packageRootName + "." + packageName.substring(1);
            String rootClassName = this.getClassNameFromFile(inFile);
            List<String> outClasses = this.convert(new FileInputStream(inFile), packageName, rootClassName, accessor, charset, subClassHandling, rootClassName);
            for (String outClass : outClasses) {
                Matcher classNameMatcher = re_className.matcher(outClass);
                if (!classNameMatcher.find()) continue;
                String className = classNameMatcher.group(1);
                Path outPath = Paths.get(outputPath, packageName.replace('.', '/'), className + ".java");
                outPath.getParent().toFile().mkdirs();
                System.out.println("  " + outPath);
                Files.write(outPath, outClass.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
    }

    public List<String> convert(String copybookString, String packageName, String rootClassName, String accessor, String charset, String subClassHandling, String wrapperClassName) throws Exception {
        ScriptObjectMirror results = (ScriptObjectMirror)this.invocable.invokeFunction("convertCopybook", packageName, rootClassName, copybookString, accessor, charset, subClassHandling, wrapperClassName);
        return Arrays.asList(results.values().toArray(new String[results.size()]));
    }

    public List<String> convert(InputStream copybookStream, String packageName, String rootClassName, String accessor, String charset, String subClassHandling, String wrapperClassName) throws Exception {
        return this.convert(new String(ByteUtils.toByteArray((InputStream)copybookStream), StandardCharsets.UTF_8), packageName, rootClassName, accessor, charset, subClassHandling, wrapperClassName);
    }

    private String extractJS(InputStream inputStream) throws IOException {
        String str;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder builder = new StringBuilder();
        boolean capture = false;
        int whiteSpaceOffset = 0;
        while ((str = bufferedReader.readLine()) != null) {
            if (str.indexOf("/*** convertCopybook stop ***/") > 0) {
                capture = false;
            }
            if (capture) {
                builder.append(str.substring(str.length() > whiteSpaceOffset ? whiteSpaceOffset : 0) + "\n");
            }
            if (str.indexOf("/*** convertCopybook start ***/") <= 0) continue;
            while (whiteSpaceOffset < str.length() && Character.isWhitespace(str.charAt(whiteSpaceOffset))) {
                ++whiteSpaceOffset;
            }
            capture = true;
        }
        return builder.toString();
    }

    private String getClassNameFromFile(File file) {
        String className = file.getName();
        int i = className.lastIndexOf(46);
        if (i > 0) {
            className = className.substring(0, i);
        }
        try {
            className = (String)this.invocable.invokeFunction("toClassName", className);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return className;
    }
}

