/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.base;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExceptionUnwrapper {
    private static final Set<Class<? extends Exception>> unwrappable = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(RuntimeException.class, InvocationTargetException.class)));

    private ExceptionUnwrapper() {
        throw new AssertionError((Object)"ExceptionUnwrapper is a static utility class that cannot be instantiated.");
    }

    public static Throwable unwrap(Throwable throwable) {
        return ExceptionUnwrapper.unwrap(throwable, null);
    }

    public static Throwable unwrap(Throwable throwable, StringBuilder builder) {
        Throwable thrown = throwable;
        if (thrown != null) {
            Throwable unwrapped;
            while (unwrappable.contains(thrown.getClass()) && (unwrapped = thrown.getCause()) != null) {
                if (builder != null) {
                    builder.append(thrown.getMessage()).append(" -> ");
                }
                thrown = unwrapped;
            }
        }
        return thrown;
    }
}

