/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class PathUtils {
    private static final String SUREFIRE_PATH = "surefire-reports";
    private static final String FAILSAFE_PATH = "failsafe-reports";

    private PathUtils() {
        throw new AssertionError((Object)"PathUtils is a static utility class that cannot be instantiated");
    }

    public static Path getNextPath(Path targetPath, String baseName, String extension) throws IOException {
        Objects.requireNonNull(targetPath, "[targetPath] must be non-null");
        Objects.requireNonNull(baseName, "[baseName] must be non-null");
        Objects.requireNonNull(extension, "[extension] must be non-null");
        File targetFile = targetPath.toFile();
        if (!targetFile.exists() || !targetFile.isDirectory()) {
            throw new IllegalArgumentException("[targetPath] must specify an existing directory");
        }
        if (baseName.isEmpty()) {
            throw new IllegalArgumentException("[baseName] must specify a non-empty string");
        }
        if (extension.isEmpty()) {
            throw new IllegalArgumentException("[extension] must specify a non-empty string");
        }
        Visitor visitor = new Visitor(baseName, extension);
        Files.walkFileTree(targetPath, EnumSet.noneOf(FileVisitOption.class), 1, visitor);
        return targetPath.resolve(visitor.getNewName());
    }

    public static String getBaseDir() {
        Path currentRelativePath = Paths.get(System.getProperty("user.dir"), new String[0]);
        return currentRelativePath.toAbsolutePath().toString();
    }

    private static class Visitor
    implements FileVisitor<Path> {
        private String baseName;
        private String extension;
        private int base;
        private int ext;
        private PathMatcher pathMatcher;
        private List<Integer> intList = new ArrayList<Integer>();

        Visitor(String baseName, String extension) {
            this.baseName = baseName;
            this.extension = extension;
            this.base = baseName.length();
            this.ext = extension.length() + 1;
            this.pathMatcher = FileSystems.getDefault().getPathMatcher("regex:\\Q" + baseName + "\\E(-\\d+)?\\." + extension);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile() && this.pathMatcher.matches(file.getFileName())) {
                String name = file.getFileName().toString();
                String iStr = "0" + name.substring(this.base, name.length() - this.ext);
                iStr = iStr.replace("0-", "");
                this.intList.add(Integer.valueOf(iStr) + 1);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public String getNewName() {
            String newName;
            if (this.intList.isEmpty()) {
                newName = this.baseName + "." + this.extension;
            } else {
                Collections.sort(this.intList, Collections.reverseOrder());
                newName = this.baseName + "-" + this.intList.get(0) + "." + this.extension;
            }
            return newName;
        }
    }

    public static enum ReportsDirectory {
        SUREFIRE_1("(Test)(.*)", "surefire-reports"),
        SUREFIRE_2("(.*)(Test)", "surefire-reports"),
        SUREFIRE_3("(.*)(Tests)", "surefire-reports"),
        SUREFIRE_4("(.*)(TestCase)", "surefire-reports"),
        FAILSAFE_1("(IT)(.*)", "failsafe-reports"),
        FAILSAFE_2("(.*)(IT)", "failsafe-reports"),
        FAILSAFE_3("(.*)(ITCase)", "failsafe-reports"),
        ARTIFACT(".*", "artifact-capture");

        private String regex;
        private String folder;

        private ReportsDirectory(String regex, String folder) {
            this.regex = regex;
            this.folder = folder;
        }

        public String getRegEx() {
            return this.regex;
        }

        public String getFolder() {
            return this.folder;
        }

        public Path getPath() {
            return ReportsDirectory.getTargetPath().resolve(this.folder);
        }

        public static ReportsDirectory fromObject(Object obj) {
            String name = obj.getClass().getSimpleName();
            for (ReportsDirectory constant : ReportsDirectory.values()) {
                if (!name.matches(constant.regex)) continue;
                return constant;
            }
            throw new IllegalStateException("Someone removed the 'default' pattern from this enumeration");
        }

        public static Path getPathForObject(Object obj) {
            ReportsDirectory constant = ReportsDirectory.fromObject(obj);
            return ReportsDirectory.getTargetPath().resolve(constant.folder);
        }

        private static Path getTargetPath() {
            return Paths.get(PathUtils.getBaseDir(), "target");
        }
    }
}

