/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.ArtifactType;
import com.nordstrom.automation.junit.AtomIdentity;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.common.file.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.junit.runner.Description;

public class ArtifactCollector<T extends ArtifactType>
extends AtomIdentity {
    private static final ConcurrentHashMap<Integer, List<ArtifactCollector<? extends ArtifactType>>> WATCHER_MAP = new ConcurrentHashMap();
    private static final Function<Integer, List<ArtifactCollector<? extends ArtifactType>>> NEW_INSTANCE = new Function<Integer, List<ArtifactCollector<? extends ArtifactType>>>(){

        @Override
        public List<ArtifactCollector<? extends ArtifactType>> apply(Integer input) {
            return new ArrayList<ArtifactCollector<? extends ArtifactType>>();
        }
    };
    private final T provider;
    private final List<Path> artifactPaths = new ArrayList<Path>();

    public ArtifactCollector(Object instance, T provider) {
        super(instance);
        this.provider = provider;
    }

    @Override
    public void starting(Description description) {
        super.starting(description);
        List<ArtifactCollector<? extends ArtifactType>> watcherList = LifecycleHooks.computeIfAbsent(WATCHER_MAP, description.hashCode(), NEW_INSTANCE);
        watcherList.add(this);
    }

    public void failed(Throwable e, Description description) {
        this.captureArtifact(e);
    }

    public Optional<Path> captureArtifact(Throwable reason) {
        Path artifactPath;
        if (!((ArtifactType)this.provider).canGetArtifact(this.getInstance())) {
            return Optional.empty();
        }
        byte[] artifact = ((ArtifactType)this.provider).getArtifact(this.getInstance(), reason);
        if (artifact == null || artifact.length == 0) {
            return Optional.empty();
        }
        Path collectionPath = this.getCollectionPath();
        if (!collectionPath.toFile().exists()) {
            try {
                Files.createDirectories(collectionPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (((ArtifactType)this.provider).getLogger() != null) {
                    String messageTemplate = "Unable to create collection directory ({}); no artifact was captured";
                    ((ArtifactType)this.provider).getLogger().warn(messageTemplate, (Object)collectionPath, (Object)e);
                }
                return Optional.empty();
            }
        }
        try {
            artifactPath = PathUtils.getNextPath((Path)collectionPath, (String)this.getArtifactBaseName(), (String)((ArtifactType)this.provider).getArtifactExtension());
        }
        catch (IOException e) {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().warn("Unable to get output path; no artifact was captured", (Throwable)e);
            }
            return Optional.empty();
        }
        try {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().info("Saving captured artifact to ({}).", (Object)artifactPath);
            }
            Files.write(artifactPath, artifact, new OpenOption[0]);
        }
        catch (IOException e) {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().warn("I/O error saving to ({}); no artifact was captured", (Object)artifactPath, (Object)e);
            }
            return Optional.empty();
        }
        this.recordArtifactPath(artifactPath);
        return Optional.of(artifactPath);
    }

    private Path getCollectionPath() {
        Path collectionPath = PathUtils.ReportsDirectory.getPathForObject((Object)this.getInstance());
        return collectionPath.resolve(((ArtifactType)this.provider).getArtifactPath(this.getInstance()));
    }

    private String getArtifactBaseName() {
        int hashcode = this.getParameters().hashCode();
        if (hashcode != 0) {
            String hashStr = String.format("%08X", hashcode);
            return this.getSanitizedName() + "-" + hashStr;
        }
        return this.getSanitizedName();
    }

    private String getSanitizedName() {
        return this.getDescription().getMethodName().replaceAll("[\\/:*?\"<>|]", "_");
    }

    private void recordArtifactPath(Path artifactPath) {
        this.artifactPaths.add(artifactPath);
    }

    public Optional<List<Path>> retrieveArtifactPaths() {
        if (this.artifactPaths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.artifactPaths);
    }

    public T getArtifactProvider() {
        return this.provider;
    }

    public static <S extends ArtifactCollector<? extends ArtifactType>> Optional<S> getWatcher(Description description, Class<S> watcherType) {
        List<ArtifactCollector<? extends ArtifactType>> watcherList = WATCHER_MAP.get(description.hashCode());
        if (watcherList != null) {
            for (ArtifactCollector<? extends ArtifactType> watcher : watcherList) {
                if (watcher.getClass() != watcherType) continue;
                return Optional.of(watcher);
            }
        }
        return Optional.empty();
    }

    static void releaseWatchersOf(Description description) {
        WATCHER_MAP.remove(description.hashCode());
    }
}

