/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.DescribeChild;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.Run;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.theories.Theory;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@Ignore
public class AtomicTest {
    private final Object runner = Run.getThreadRunner();
    private final Description description;
    private FrameworkMethod identity;
    private final List<FrameworkMethod> particles;
    private Throwable thrown;
    private static final Pattern PARAM = Pattern.compile("[(\\[]");
    private static final List<Class<? extends Annotation>> TEST_TYPES = Arrays.asList(Test.class, Theory.class);

    public AtomicTest(Description description) {
        this.description = description;
        this.particles = this.getParticles(this.runner, description);
        this.identity = this.particles.isEmpty() ? null : this.particles.get(0);
    }

    public Object getRunner() {
        return this.runner;
    }

    public Description getDescription() {
        return this.description;
    }

    void setIdentity(FrameworkMethod method) {
        this.identity = method;
        this.particles.set(0, method);
    }

    public FrameworkMethod getIdentity() {
        return this.identity;
    }

    public List<FrameworkMethod> getParticles() {
        return this.particles;
    }

    public boolean hasConfiguration() {
        return this.particles.size() > 1;
    }

    void setThrowable(Throwable thrown) {
        this.thrown = thrown;
    }

    public Throwable getThrowable() {
        return this.thrown;
    }

    public boolean includes(FrameworkMethod method) {
        return this.particles.contains(method);
    }

    public boolean isTheory() {
        return AtomicTest.isTheory(this.description);
    }

    public static boolean isTheory(Description description) {
        return DescribeChild.isPermutation(description);
    }

    public boolean isTest() {
        return AtomicTest.isTest(this.description);
    }

    public static boolean isTest(Description description) {
        return AtomicTest.getTestAnnotation(description) != null;
    }

    public static Annotation getTestAnnotation(Description description) {
        for (Annotation annotation : description.getAnnotations()) {
            if (!TEST_TYPES.contains(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public String toString() {
        return this.description.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AtomicTest)) {
            return false;
        }
        AtomicTest that = (AtomicTest)o;
        return Objects.equals(this.runner, that.runner) && Objects.equals(this.identity, that.identity);
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    private List<FrameworkMethod> getParticles(Object runner, Description description) {
        ArrayList<FrameworkMethod> particles = new ArrayList<FrameworkMethod>();
        if (AtomicTest.isTest(description)) {
            TestClass testClass = LifecycleHooks.getTestClassOf(runner);
            String methodName = description.getMethodName();
            Matcher matcher = PARAM.matcher(methodName);
            if (matcher.find()) {
                methodName = methodName.substring(0, matcher.start());
            }
            FrameworkMethod identity = null;
            for (FrameworkMethod method : testClass.getAnnotatedMethods()) {
                if (!method.getName().equals(methodName)) continue;
                identity = method;
                break;
            }
            if (identity != null) {
                particles.add(identity);
                particles.addAll(testClass.getAnnotatedMethods(Before.class));
                particles.addAll(testClass.getAnnotatedMethods(After.class));
            } else {
                throw new IllegalStateException("Identity method not found");
            }
        }
        return particles;
    }
}

