/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.ArtifactCollector;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.CreateTest;
import com.nordstrom.automation.junit.GetAnnotations;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RunReflectiveCall;
import com.nordstrom.automation.junit.TestMethodDescription;
import com.nordstrom.common.base.UncheckedThrow;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.Argument;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;

public class EachTestNotifierInit {
    private static final Map<Integer, AtomicTest> DESCRIPTION_TO_ATOMICTEST = new ConcurrentHashMap<Integer, AtomicTest>();
    private static final Map<String, Integer> TARGET_TO_DESCRIPTION = new ConcurrentHashMap<String, Integer>();
    private static final Map<Integer, Object> DESCRIPTION_TO_TARGET = new ConcurrentHashMap<Integer, Object>();
    private static final Map<Integer, Integer> HASHCODE_TO_DESCRIPTION = new ConcurrentHashMap<Integer, Integer>();

    public static void interceptor(@Argument(value=0) RunNotifier notifier, @Argument(value=1) Description description) {
        if (AtomicTest.isTest(description)) {
            AtomicTest atomicTest = EachTestNotifierInit.newAtomicTestFor(description);
            Object runner = atomicTest.getRunner();
            FrameworkMethod method = null;
            List children = (List)LifecycleHooks.invoke(runner, "getChildren", new Object[0]);
            for (Object child : children) {
                if (!description.equals((Object)LifecycleHooks.describeChild(runner, child))) continue;
                method = (FrameworkMethod)child;
                break;
            }
            if (method == null) {
                try {
                    Map assoc = (Map)LifecycleHooks.getFieldValue(runner, "methodDescriptions");
                    for (Map.Entry entry : assoc.entrySet()) {
                        if (!description.equals(entry.getValue())) continue;
                        method = (FrameworkMethod)entry.getKey();
                        break;
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException assoc) {
                    // empty catch block
                }
            }
            if (method != null) {
                Object target = CreateTest.getTargetFor(runner, method);
                if (target != null) {
                    EachTestNotifierInit.createMappingsFor(description.hashCode(), target);
                } else {
                    HASHCODE_TO_DESCRIPTION.put(Objects.hash(runner, method.toString()), description.hashCode());
                }
            } else {
                throw new IllegalStateException("unable to determine method");
            }
        }
    }

    static AtomicTest newAtomicTestFor(Description description) {
        AtomicTest atomicTest = EachTestNotifierInit.getAtomicTestOf(description);
        if (atomicTest == null) {
            atomicTest = new AtomicTest(description);
            DESCRIPTION_TO_ATOMICTEST.put(description.hashCode(), atomicTest);
        }
        return atomicTest;
    }

    static AtomicTest getAtomicTestOf(Description description) {
        if (description != null) {
            return DESCRIPTION_TO_ATOMICTEST.get(description.hashCode());
        }
        return null;
    }

    static Object getTargetOf(Description description) {
        return DESCRIPTION_TO_TARGET.get(description.hashCode());
    }

    static AtomicTest getAtomicTestOf(EachTestNotifier notifier) {
        return DESCRIPTION_TO_ATOMICTEST.get(EachTestNotifierInit.getDescriptionOf(notifier).hashCode());
    }

    static boolean setTestTarget(Object runner, FrameworkMethod method, Object target) {
        Integer descriptionHash = EachTestNotifierInit.getDescriptionHashFor(runner, method);
        if (descriptionHash != null) {
            EachTestNotifierInit.createMappingsFor(descriptionHash, target);
            return true;
        }
        return false;
    }

    static void createMappingsFor(Integer descriptionHash, Object target) {
        TARGET_TO_DESCRIPTION.put(LifecycleHooks.toMapKey(target), descriptionHash);
        DESCRIPTION_TO_TARGET.put(descriptionHash, target);
    }

    static void releaseMappingsFor(EachTestNotifier notifier) {
        Description description = EachTestNotifierInit.getDescriptionOf(notifier);
        AtomicTest atomicTest = EachTestNotifierInit.releaseAtomicTestOf(description);
        HASHCODE_TO_DESCRIPTION.remove(Objects.hash(atomicTest.getRunner(), atomicTest.getIdentity().toString()));
        Object target = DESCRIPTION_TO_TARGET.remove(description.hashCode());
        if (target != null) {
            TARGET_TO_DESCRIPTION.remove(LifecycleHooks.toMapKey(target));
        }
        RunReflectiveCall.releaseCallableOf(description);
        ArtifactCollector.releaseWatchersOf(description);
        CreateTest.releaseMappingsFor(atomicTest.getRunner(), atomicTest.getIdentity(), target);
        GetAnnotations.releaseAnnotationsFor(atomicTest.getIdentity());
        TestMethodDescription.releaseDescriptionFor(atomicTest.getIdentity());
    }

    static AtomicTest releaseAtomicTestOf(Description description) {
        return DESCRIPTION_TO_ATOMICTEST.remove(description.hashCode());
    }

    static AtomicTest getAtomicTestOf(Object target) {
        Integer descriptionHash;
        if (target != null && (descriptionHash = TARGET_TO_DESCRIPTION.get(LifecycleHooks.toMapKey(target))) != null) {
            return DESCRIPTION_TO_ATOMICTEST.get(descriptionHash);
        }
        return null;
    }

    private static Description getDescriptionOf(EachTestNotifier notifier) {
        try {
            return (Description)LifecycleHooks.getFieldValue(notifier, "description");
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e);
        }
    }

    private static Integer getDescriptionHashFor(Object runner, FrameworkMethod method) {
        return HASHCODE_TO_DESCRIPTION.get(Objects.hash(runner, method.toString()));
    }
}

