/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.runners.model.FrameworkMethod;

public class GetAnnotations {
    private static final Map<String, Annotation[]> ANNOTATIONS = new ConcurrentHashMap<String, Annotation[]>();

    public static Annotation[] intercept(@This FrameworkMethod method) throws Exception {
        return GetAnnotations.getAnnotationsFor(method);
    }

    static Annotation[] getAnnotationsFor(FrameworkMethod method) {
        Annotation[] annotations = ANNOTATIONS.get(method.toString());
        if (annotations == null) {
            annotations = method.getMethod().getAnnotations();
            ANNOTATIONS.put(method.toString(), annotations);
        }
        return annotations;
    }

    static void releaseAnnotationsFor(FrameworkMethod method) {
        ANNOTATIONS.remove(method.toString());
    }
}

