/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.settings.SettingsCore;
import com.nordstrom.common.base.UncheckedThrow;
import java.io.IOException;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class JUnitConfig
extends SettingsCore<JUnitSettings> {
    private static final String SETTINGS_FILE = "junit.properties";
    private static final ThreadLocal<JUnitConfig> junitConfig = new InheritableThreadLocal<JUnitConfig>(){

        @Override
        protected JUnitConfig initialValue() {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(LifecycleHooks.class.getClassLoader());
                JUnitConfig jUnitConfig = new JUnitConfig();
                return jUnitConfig;
            }
            catch (IOException | ConfigurationException e) {
                throw UncheckedThrow.throwUnchecked((Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    };

    public JUnitConfig() throws ConfigurationException, IOException {
        super(JUnitSettings.class);
    }

    public static JUnitConfig getConfig() {
        return junitConfig.get();
    }

    public String getSettingsPath() {
        return SETTINGS_FILE;
    }

    public static enum JUnitSettings implements SettingsCore.SettingsAPI
    {
        TEST_TIMEOUT("junit.timeout.test", null),
        TIMEOUT_RULE("junit.timeout.rule", null),
        MAX_RETRY("junit.max.retry", "0"),
        RETRY_MORE_INFO("junit.retry.more.info", "false");

        private final String propertyName;
        private final String defaultValue;

        private JUnitSettings(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.propertyName;
        }

        public String val() {
            return this.defaultValue;
        }
    }
}

