/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.Run;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.experimental.theories.Theories;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class MethodBlock {
    private static final ThreadLocal<ConcurrentMap<String, DepthGauge>> METHOD_DEPTH;
    private static final Function<String, DepthGauge> NEW_INSTANCE;
    private static final Map<String, Statement> RUNNER_TO_STATEMENT;

    public static Statement intercept(final @This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) FrameworkMethod method) throws Exception {
        DepthGauge depthGauge = LifecycleHooks.computeIfAbsent(METHOD_DEPTH.get(), LifecycleHooks.toMapKey(runner), NEW_INSTANCE);
        depthGauge.increaseDepth();
        Statement statement = (Statement)LifecycleHooks.callProxy(proxy);
        if (0 == depthGauge.decreaseDepth()) {
            METHOD_DEPTH.get().remove(LifecycleHooks.toMapKey(runner));
            try {
                Object parent = LifecycleHooks.getFieldValue(runner, "this$0");
                if (parent instanceof Theories.TheoryAnchor) {
                    RUNNER_TO_STATEMENT.put(LifecycleHooks.toMapKey(runner), statement);
                    statement = new Statement(){
                        final Object threadRunner;
                        {
                            this.threadRunner = runner;
                        }

                        public void evaluate() throws Throwable {
                            Run.pushThreadRunner(this.threadRunner);
                        }
                    };
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return statement;
    }

    static Statement getStatementOf(Object runner) {
        return RUNNER_TO_STATEMENT.remove(LifecycleHooks.toMapKey(runner));
    }

    static {
        RUNNER_TO_STATEMENT = new ConcurrentHashMap<String, Statement>();
        METHOD_DEPTH = new ThreadLocal<ConcurrentMap<String, DepthGauge>>(){

            @Override
            protected ConcurrentMap<String, DepthGauge> initialValue() {
                return new ConcurrentHashMap<String, DepthGauge>();
            }
        };
        NEW_INSTANCE = new Function<String, DepthGauge>(){

            @Override
            public DepthGauge apply(String input) {
                return new DepthGauge();
            }
        };
    }
}

