/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.EachTestNotifierInit;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.JUnitRetryAnalyzer;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodBlock;
import com.nordstrom.automation.junit.NoRetry;
import com.nordstrom.automation.junit.RetriedTest;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHandler {
    private static final Map<String, Boolean> METHOD_TO_RETRY = new ConcurrentHashMap<String, Boolean>();
    private static final ServiceLoader<JUnitRetryAnalyzer> retryAnalyzerLoader;
    private static final Logger LOGGER;

    private RetryHandler() {
        throw new AssertionError((Object)"RetryHandler is a static utility class that cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Throwable runChildWithRetry(Object runner, FrameworkMethod method, Statement statement, RunNotifier notifier, int maxRetry) {
        boolean doRetry = true;
        Throwable thrown = null;
        Statement iteration = statement;
        Description description = (Description)LifecycleHooks.invoke(runner, "describeChild", method);
        AtomicInteger count = new AtomicInteger(maxRetry);
        while (true) {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            AtomicTest atomicTest = EachTestNotifierInit.getAtomicTestOf(description);
            atomicTest.setIdentity(method);
            if (atomicTest.isTheory()) {
                iteration = MethodBlock.getStatementOf(runner);
            }
            eachNotifier.fireTestStarted();
            try {
                iteration.evaluate();
                doRetry = false;
            }
            catch (AssumptionViolatedException e) {
                doRetry = RetryHandler.doRetry(method, e, count);
                if (doRetry) {
                    description = RetriedTest.proxyFor(description, e);
                    eachNotifier.fireTestIgnored();
                } else {
                    thrown = e;
                    eachNotifier.addFailedAssumption(e);
                }
            }
            catch (Throwable e) {
                doRetry = RetryHandler.doRetry(method, e, count);
                if (doRetry) {
                    description = RetriedTest.proxyFor(description, e);
                    eachNotifier.fireTestIgnored();
                } else {
                    thrown = e;
                    eachNotifier.addFailure(e);
                }
            }
            finally {
                eachNotifier.fireTestFinished();
            }
            if (!doRetry) return thrown;
            try {
                METHOD_TO_RETRY.put(LifecycleHooks.toMapKey(method), true);
                iteration = (Statement)LifecycleHooks.invoke(runner, "methodBlock", method);
                continue;
            }
            finally {
                METHOD_TO_RETRY.remove(LifecycleHooks.toMapKey(method));
                continue;
            }
            break;
        }
    }

    static boolean doRetry(FrameworkMethod method, Throwable thrown, AtomicInteger retryCounter) {
        boolean doRetry = false;
        if (retryCounter.decrementAndGet() > -1 && RetryHandler.isRetriable(method, thrown)) {
            doRetry = true;
            LOGGER.warn("### RETRY ### {}", (Object)method, (Object)RetryHandler.getThrowableToLog(thrown));
        }
        return doRetry;
    }

    static int getMaxRetry(Object runner, FrameworkMethod method) {
        int maxRetry = 0;
        NoRetry noRetryOnMethod = (NoRetry)method.getAnnotation(NoRetry.class);
        NoRetry noRetryOnClass = method.getDeclaringClass().getAnnotation(NoRetry.class);
        if (Boolean.FALSE.equals(LifecycleHooks.invoke(runner, "isIgnored", method)) && noRetryOnMethod == null && noRetryOnClass == null) {
            maxRetry = LifecycleHooks.getConfig().getInteger(JUnitConfig.JUnitSettings.MAX_RETRY.key(), 0);
        }
        return maxRetry;
    }

    static boolean doRetryFor(FrameworkMethod method) {
        Boolean doRetry = METHOD_TO_RETRY.get(LifecycleHooks.toMapKey(method));
        return doRetry != null ? doRetry : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRetriable(FrameworkMethod method, Throwable thrown) {
        ServiceLoader<JUnitRetryAnalyzer> serviceLoader = retryAnalyzerLoader;
        synchronized (serviceLoader) {
            for (JUnitRetryAnalyzer analyzer : retryAnalyzerLoader) {
                if (!analyzer.retry(method, thrown)) continue;
                return true;
            }
        }
        return false;
    }

    private static Throwable getThrowableToLog(Throwable thrown) {
        if (LOGGER.isDebugEnabled() || LifecycleHooks.getConfig().getBoolean(JUnitConfig.JUnitSettings.RETRY_MORE_INFO.key())) {
            return thrown;
        }
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RetryHandler.class);
        retryAnalyzerLoader = ServiceLoader.load(JUnitRetryAnalyzer.class);
    }
}

