/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RunnerWatcher;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run {
    private static final ThreadLocal<Deque<Object>> RUNNER_STACK;
    private static final ThreadLocal<ConcurrentMap<String, DepthGauge>> METHOD_DEPTH;
    private static final Function<String, DepthGauge> NEW_INSTANCE;
    private static final Set<String> START_NOTIFIED;
    private static final Map<String, Object> CHILD_TO_PARENT;
    private static final Map<String, RunNotifier> RUNNER_TO_NOTIFIER;
    private static final Set<String> NOTIFIERS;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) RunNotifier notifier) throws Exception {
        DepthGauge depthGauge = LifecycleHooks.computeIfAbsent(METHOD_DEPTH.get(), LifecycleHooks.toMapKey(runner), NEW_INSTANCE);
        try {
            if (0 == depthGauge.increaseDepth()) {
                RUNNER_TO_NOTIFIER.put(LifecycleHooks.toMapKey(runner), notifier);
                Run.pushThreadRunner(runner);
                Run.attachRunListeners(runner, notifier);
                Run.fireRunStarted(runner);
            }
            LifecycleHooks.callProxy(proxy);
        }
        finally {
            if (0 == depthGauge.decreaseDepth()) {
                METHOD_DEPTH.get().remove(LifecycleHooks.toMapKey(runner));
                Run.fireRunFinished(runner);
                Run.popThreadRunner();
                RUNNER_TO_NOTIFIER.remove(LifecycleHooks.toMapKey(runner));
            }
        }
    }

    static RunNotifier getNotifierOf(Object runner) {
        return RUNNER_TO_NOTIFIER.get(LifecycleHooks.toMapKey(runner));
    }

    static Object getParentOf(Object child) {
        return CHILD_TO_PARENT.get(LifecycleHooks.toMapKey(child));
    }

    static void pushThreadRunner(Object runner) {
        RUNNER_STACK.get().push(runner);
    }

    static Object popThreadRunner() {
        return RUNNER_STACK.get().pop();
    }

    static Object getThreadRunner() {
        return RUNNER_STACK.get().peek();
    }

    static boolean fireRunStarted(Object runner) {
        if (START_NOTIFIED.add(LifecycleHooks.toMapKey(runner))) {
            for (Object child : (List)LifecycleHooks.invoke(runner, "getChildren", new Object[0])) {
                CHILD_TO_PARENT.put(LifecycleHooks.toMapKey(child), runner);
            }
            LOGGER.debug("runStarted: {}", runner);
            for (RunnerWatcher watcher : LifecycleHooks.getRunnerWatchers()) {
                watcher.runStarted(runner);
            }
            return true;
        }
        return false;
    }

    static void fireRunFinished(Object runner) {
        LOGGER.debug("runFinished: {}", runner);
        for (RunnerWatcher watcher : LifecycleHooks.getRunnerWatchers()) {
            watcher.runFinished(runner);
        }
        START_NOTIFIED.remove(LifecycleHooks.toMapKey(runner));
        for (RunnerWatcher child : (List)LifecycleHooks.invoke(runner, "getChildren", new Object[0])) {
            CHILD_TO_PARENT.remove(LifecycleHooks.toMapKey(child));
        }
    }

    static void attachRunListeners(Object runner, RunNotifier notifier) throws Exception {
        if (NOTIFIERS.add(LifecycleHooks.toMapKey(notifier))) {
            Description description = (Description)LifecycleHooks.invoke(runner, "getDescription", new Object[0]);
            for (RunListener listener : LifecycleHooks.getRunListeners()) {
                notifier.removeListener(listener);
                notifier.addListener(listener);
                listener.testRunStarted(description);
            }
        }
    }

    static {
        START_NOTIFIED = new CopyOnWriteArraySet<String>();
        CHILD_TO_PARENT = new ConcurrentHashMap<String, Object>();
        RUNNER_TO_NOTIFIER = new ConcurrentHashMap<String, RunNotifier>();
        NOTIFIERS = new CopyOnWriteArraySet<String>();
        LOGGER = LoggerFactory.getLogger(Run.class);
        RUNNER_STACK = new ThreadLocal<Deque<Object>>(){

            @Override
            protected Deque<Object> initialValue() {
                return new ArrayDeque<Object>();
            }
        };
        METHOD_DEPTH = new ThreadLocal<ConcurrentMap<String, DepthGauge>>(){

            @Override
            protected ConcurrentMap<String, DepthGauge> initialValue() {
                return new ConcurrentHashMap<String, DepthGauge>();
            }
        };
        NEW_INSTANCE = new Function<String, DepthGauge>(){

            @Override
            public DepthGauge apply(String input) {
                return new DepthGauge();
            }
        };
    }
}

