/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RetryHandler;
import com.nordstrom.automation.junit.Run;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.Ignore;
import org.junit.experimental.theories.Theories;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class RunChild {
    private static final Map<String, Boolean> DID_NOTIFY = new ConcurrentHashMap<String, Boolean>();

    public static void intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) Object child, @Argument(value=1) RunNotifier notifier) throws Exception {
        int maxRetry;
        FrameworkMethod method;
        String mapKey = LifecycleHooks.toMapKey(runner);
        if (!DID_NOTIFY.containsKey(mapKey)) {
            DID_NOTIFY.put(mapKey, Run.fireRunStarted(runner));
            Run.attachRunListeners(runner, notifier);
        }
        if (!(runner instanceof Theories) && child instanceof FrameworkMethod && null == (method = (FrameworkMethod)child).getAnnotation(Ignore.class) && (maxRetry = RetryHandler.getMaxRetry(runner, method)) > 0) {
            Statement statement = (Statement)LifecycleHooks.invoke(runner, "methodBlock", method);
            RetryHandler.runChildWithRetry(runner, method, statement, notifier, maxRetry);
            return;
        }
        LifecycleHooks.callProxy(proxy);
    }

    static void finished() {
        Object runner = Run.getThreadRunner();
        Boolean didNotify = DID_NOTIFY.remove(LifecycleHooks.toMapKey(runner));
        if (didNotify != null && didNotify.booleanValue()) {
            Run.fireRunFinished(runner);
        }
    }
}

