/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.CreateTest;
import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.EachTestNotifierInit;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.common.base.UncheckedThrow;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunReflectiveCall {
    private static final Map<Integer, ReflectiveCallable> DESCRIPTION_TO_CALLABLE = new ConcurrentHashMap<Integer, ReflectiveCallable>();
    private static final ThreadLocal<ConcurrentMap<Integer, DepthGauge>> METHOD_DEPTH;
    private static final Function<Integer, DepthGauge> NEW_INSTANCE;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@This ReflectiveCallable callable, @SuperCall Callable<?> proxy) throws Exception {
        Object child = null;
        Object runner = null;
        boolean didPush = false;
        try {
            Object target;
            child = LifecycleHooks.getFieldValue(callable, "this$0");
            runner = Run.getThreadRunner();
            if (runner == null) {
                runner = Run.getParentOf(child);
            }
            if (runner == null && (target = LifecycleHooks.getFieldValue(callable, "val$target")) != null && (runner = CreateTest.getRunnerFor(target)) != null) {
                Run.pushThreadRunner(runner);
                didPush = true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException target) {
            // empty catch block
        }
        Object result = null;
        Throwable thrown = null;
        try {
            RunReflectiveCall.fireBeforeInvocation(runner, child, callable);
            result = LifecycleHooks.callProxy(proxy);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            RunReflectiveCall.fireAfterInvocation(runner, child, callable, thrown);
            if (didPush) {
                Run.popThreadRunner();
            }
        }
        if (thrown != null) {
            throw UncheckedThrow.throwUnchecked((Throwable)thrown);
        }
        return result;
    }

    static Object getTargetFor(Description description) {
        Object target = null;
        ReflectiveCallable callable = RunReflectiveCall.getCallableOf(description);
        if (callable != null) {
            try {
                target = LifecycleHooks.getFieldValue(callable, "val$target");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return target;
    }

    static ReflectiveCallable getCallableOf(Description description) {
        return DESCRIPTION_TO_CALLABLE.get(description.hashCode());
    }

    static void releaseCallableOf(Description description) {
        DESCRIPTION_TO_CALLABLE.remove(description.hashCode());
    }

    private static boolean fireBeforeInvocation(Object runner, Object child, ReflectiveCallable callable) {
        DepthGauge depthGauge;
        if (runner != null && child != null && 0 == (depthGauge = LifecycleHooks.computeIfAbsent(METHOD_DEPTH.get(), callable.hashCode(), NEW_INSTANCE)).increaseDepth()) {
            if (child instanceof FrameworkMethod) {
                FrameworkMethod method = (FrameworkMethod)child;
                Description description = LifecycleHooks.describeChild(runner, method);
                if (LOGGER.isDebugEnabled()) {
                    try {
                        LOGGER.debug("beforeInvocation: {}", description != null ? description : method);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (description != null && AtomicTest.isTest(description)) {
                    DESCRIPTION_TO_CALLABLE.put(description.hashCode(), callable);
                    Object target = RunReflectiveCall.getTargetFor(description);
                    if (target != null) {
                        CreateTest.createMappingsFor(runner, method, target);
                        EachTestNotifierInit.newAtomicTestFor(description);
                        EachTestNotifierInit.setTestTarget(runner, method, target);
                    }
                }
            }
            for (MethodWatcher<?> watcher : LifecycleHooks.getMethodWatchers()) {
                if (!watcher.supportedType().isInstance(child)) continue;
                watcher.beforeInvocation(runner, child, callable);
            }
            return true;
        }
        return false;
    }

    private static boolean fireAfterInvocation(Object runner, Object child, ReflectiveCallable callable, Throwable thrown) {
        DepthGauge depthGauge;
        if (runner != null && child != null && 0 == (depthGauge = (DepthGauge)METHOD_DEPTH.get().get(callable.hashCode())).decreaseDepth()) {
            METHOD_DEPTH.get().remove(callable.hashCode());
            if (child instanceof FrameworkMethod && LOGGER.isDebugEnabled()) {
                try {
                    Description description = LifecycleHooks.describeChild(runner, child);
                    LOGGER.debug("afterInvocation: {}", description != null ? description : child);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (MethodWatcher<?> watcher : LifecycleHooks.getMethodWatchers()) {
                if (!watcher.supportedType().isInstance(child)) continue;
                watcher.afterInvocation(runner, child, callable, thrown);
            }
            return true;
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RunReflectiveCall.class);
        METHOD_DEPTH = new ThreadLocal<ConcurrentMap<Integer, DepthGauge>>(){

            @Override
            protected ConcurrentMap<Integer, DepthGauge> initialValue() {
                return new ConcurrentHashMap<Integer, DepthGauge>();
            }
        };
        NEW_INSTANCE = new Function<Integer, DepthGauge>(){

            @Override
            public DepthGauge apply(Integer input) {
                return new DepthGauge();
            }
        };
    }
}

