/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.UniqueIdAccessor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import junitparams.Parameters;
import junitparams.internal.TestMethod;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;

public class TestMethodDescription {
    private static final Map<Integer, Description> TESTMETHOD_TO_DESCRIPTION = new ConcurrentHashMap<Integer, Description>();

    public static Description intercept(@This TestMethod testMethod, @SuperCall Callable<?> proxy) throws Exception {
        Description description = TESTMETHOD_TO_DESCRIPTION.get(testMethod.hashCode());
        if (description == null) {
            description = TestMethodDescription.computeDescription(testMethod, proxy);
            TESTMETHOD_TO_DESCRIPTION.put(testMethod.hashCode(), description);
        }
        return description;
    }

    private static Description computeDescription(TestMethod testMethod, Callable<?> proxy) throws Exception {
        Description original = (Description)LifecycleHooks.callProxy(proxy);
        if (original.isTest()) {
            return original;
        }
        int parentIndex = 0;
        int childIndex = 0;
        ArrayList children = original.getChildren();
        Method method = testMethod.frameworkMethod().getMethod();
        int count = method.getAnnotations().length;
        Annotation[] parentAnnotations = new Annotation[count - 1];
        Annotation[] childAnnotations = new Annotation[count - 1];
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Parameters) {
                parentAnnotations[parentIndex++] = annotation;
                continue;
            }
            if (annotation instanceof Test) {
                childAnnotations[childIndex++] = annotation;
                continue;
            }
            parentAnnotations[parentIndex++] = annotation;
            childAnnotations[childIndex++] = annotation;
        }
        Description parent = Description.createTestDescription(method.getDeclaringClass(), (String)method.getName(), (Annotation[])parentAnnotations);
        for (Description description : children) {
            String displayName = description.getDisplayName();
            Serializable uniqueId = ((UniqueIdAccessor)description).getUniqueId();
            parent.addChild(Description.createSuiteDescription((String)displayName, (Serializable)uniqueId, (Annotation[])childAnnotations));
        }
        return parent;
    }

    static void releaseDescriptionFor(FrameworkMethod method) {
        TESTMETHOD_TO_DESCRIPTION.remove(method.hashCode());
    }
}

