/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.FieldsForAnnotationsAccessor;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.common.base.UncheckedThrow;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class TimeoutUtils {
    TimeoutUtils() {
    }

    static void applyTestTimeout(Object runner, FrameworkMethod method, Object target) {
        Test annotation;
        FrameworkMethod identity = TimeoutUtils.getIdentity(runner, method);
        Test test = annotation = identity != null ? (Test)identity.getAnnotation(Test.class) : null;
        if (annotation == null) {
            return;
        }
        long uberTimeout = -1L;
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key())) {
            uberTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key());
        }
        long ruleTimeout = -1L;
        TestClass testClass = LifecycleHooks.getTestClassOf(runner);
        Map<Class<? extends Annotation>, List<FrameworkField>> fieldsMap = ((FieldsForAnnotationsAccessor)testClass).getFieldsForAnnotations();
        List<FrameworkField> ruleFields = fieldsMap.get(Rule.class);
        if (ruleFields != null) {
            ListIterator<FrameworkField> iterator = ruleFields.listIterator();
            while (iterator.hasNext()) {
                FrameworkField ruleField = iterator.next();
                if (!Timeout.class.isAssignableFrom(ruleField.getType())) continue;
                try {
                    ruleTimeout = (Long)LifecycleHooks.invoke(ruleField.get(target), "getTimeout", new Object[]{TimeUnit.MILLISECONDS});
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    UncheckedThrow.throwUnchecked((Throwable)e);
                }
            }
        }
        if (uberTimeout == 0L || ruleTimeout == 0L) {
            MutableTest.proxyFor(identity, 0L);
        } else {
            long metaTimeout;
            long testTimeout = -1L;
            if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key())) {
                testTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key());
            }
            if (testTimeout > (metaTimeout = annotation.timeout())) {
                MutableTest.proxyFor(identity, testTimeout);
            }
        }
    }

    static void applyRuleTimeout(Object runner, FrameworkMethod method, List<TestRule> testRules) {
        long timeout;
        FrameworkMethod identity = TimeoutUtils.getIdentity(runner, method);
        Test annotation = identity != null ? (Test)identity.getAnnotation(Test.class) : null;
        long metaTimeout = annotation != null ? annotation.timeout() : 0L;
        long uberTimeout = -1L;
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key())) {
            uberTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key());
        }
        int ruleIndex = -1;
        long ruleTimeout = -1L;
        for (int i = 0; i < testRules.size(); ++i) {
            TestRule testRule = testRules.get(i);
            if (!(testRule instanceof Timeout)) continue;
            ruleIndex = i;
            ruleTimeout = (Long)LifecycleHooks.invoke(testRule, "getTimeout", new Object[]{TimeUnit.MILLISECONDS});
            break;
        }
        boolean disableTimeout = uberTimeout == 0L || ruleTimeout == 0L;
        long l = timeout = disableTimeout ? 0L : Collections.max(Arrays.asList(metaTimeout, uberTimeout, ruleTimeout));
        if (ruleIndex != -1) {
            if (ruleTimeout != timeout) {
                testRules.set(ruleIndex, (TestRule)Timeout.millis((long)timeout));
            }
        } else if (uberTimeout != -1L) {
            testRules.add((TestRule)Timeout.millis((long)timeout));
        }
    }

    static FrameworkMethod getIdentity(Object runner, FrameworkMethod method) {
        FrameworkMethod identity = method;
        if (identity != null) {
            return identity;
        }
        try {
            Object anchor = LifecycleHooks.getFieldValue(runner, "this$0");
            if (anchor instanceof Theories.TheoryAnchor) {
                identity = (FrameworkMethod)LifecycleHooks.getFieldValue(anchor, "testMethod");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return identity;
    }
}

