/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.CreateTest;
import com.nordstrom.automation.junit.Hooked;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.ShutdownListener;
import com.nordstrom.common.base.UncheckedThrow;
import com.nordstrom.common.file.PathUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.TestClass;

public class LifecycleHooks {
    private static JUnitConfig config;

    private LifecycleHooks() {
        throw new AssertionError((Object)"LifecycleHooks is a static utility class that cannot be instantiated");
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        LifecycleHooks.installTransformer(instrumentation);
    }

    public static ClassFileTransformer installTransformer(Instrumentation instrumentation) {
        TypeDescription runReflectiveCall = TypePool.Default.ofSystemLoader().describe("com.nordstrom.automation.junit.RunReflectiveCall").resolve();
        TypeDescription finished = TypePool.Default.ofSystemLoader().describe("com.nordstrom.automation.junit.Finished").resolve();
        TypeDescription createTest = TypePool.Default.ofSystemLoader().describe("com.nordstrom.automation.junit.CreateTest").resolve();
        TypeDescription runChild = TypePool.Default.ofSystemLoader().describe("com.nordstrom.automation.junit.RunChild").resolve();
        TypeDescription run = TypePool.Default.ofSystemLoader().describe("com.nordstrom.automation.junit.Run").resolve();
        TypeDescription runNotifier = TypePool.Default.ofSystemLoader().describe("org.junit.runner.notification.RunNotifier").resolve();
        MethodDescription.SignatureToken runToken = new MethodDescription.SignatureToken("run", TypeDescription.VOID, Arrays.asList(runNotifier));
        return new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.junit.internal.runners.model.ReflectiveCallable"))).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"runReflectiveCall")).intercept((Implementation)MethodDelegation.to((TypeDescription)runReflectiveCall)).implement(new Type[]{Hooked.class})).type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.junit.runners.model.RunnerScheduler"))).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"finished")).intercept((Implementation)MethodDelegation.to((TypeDescription)finished)).implement(new Type[]{Hooked.class})).type((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.junit.runners.ParentRunner"))).transform((builder, type, classLoader, module) -> builder.method((ElementMatcher)ElementMatchers.named((String)"createTest")).intercept((Implementation)MethodDelegation.to((TypeDescription)createTest)).method((ElementMatcher)ElementMatchers.named((String)"runChild")).intercept((Implementation)MethodDelegation.to((TypeDescription)runChild)).method((ElementMatcher)ElementMatchers.hasSignature((MethodDescription.SignatureToken)runToken)).intercept((Implementation)MethodDelegation.to((TypeDescription)run)).implement(new Type[]{Hooked.class})).installOn(instrumentation);
    }

    static Thread getShutdownHook(final ShutdownListener listener) {
        return new Thread(){

            @Override
            public void run() {
                listener.onShutdown();
            }
        };
    }

    static synchronized JUnitConfig getConfig() {
        if (config == null) {
            config = JUnitConfig.getConfig();
        }
        return config;
    }

    public static Object getRunnerForTarget(Object target) {
        return CreateTest.getRunnerForTarget(target);
    }

    public static Object getTargetForRunner(Object runner) {
        return CreateTest.getTargetForRunner(runner);
    }

    public static Object getParentOf(Object child) {
        return Run.getParentOf(child);
    }

    public static Object getThreadRunner() {
        return Run.getThreadRunner();
    }

    public static TestClass getTestClassOf(Object runner) {
        return (TestClass)LifecycleHooks.invoke(runner, "getTestClass", new Object[0]);
    }

    public static Description describeChild(Object target, Object child) {
        Object runner = LifecycleHooks.getRunnerForTarget(target);
        return (Description)LifecycleHooks.invoke(runner, "describeChild", child);
    }

    static void applyTimeout(Object testObj) {
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key())) {
            long defaultTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key());
            for (Method method : testObj.getClass().getDeclaredMethods()) {
                Test annotation = method.getDeclaredAnnotation(Test.class);
                if (annotation == null || annotation.timeout() >= defaultTimeout) continue;
                MutableTest.proxyFor(method).setTimeout(defaultTimeout);
            }
        }
    }

    public static Class<?> getInstanceClass(Object instance) {
        Class<?> clazz = instance.getClass();
        return instance instanceof Hooked ? clazz.getSuperclass() : clazz;
    }

    static String getSubclassName(Object testObj) {
        Class<?> testClass = testObj.getClass();
        String testClassName = testClass.getSimpleName();
        String testPackageName = testClass.getPackage().getName();
        PathUtils.ReportsDirectory constant = PathUtils.ReportsDirectory.fromObject((Object)testObj);
        switch (constant) {
            case FAILSAFE_2: 
            case FAILSAFE_3: 
            case SUREFIRE_2: 
            case SUREFIRE_3: 
            case SUREFIRE_4: {
                return testPackageName + ".Hooked" + testClassName;
            }
        }
        return testClass.getCanonicalName() + "Hooked";
    }

    static <T> T invoke(Object target, String methodName, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        Exception thrown = null;
        for (Class<?> current = target.getClass(); current != null; current = current.getSuperclass()) {
            try {
                Method method = current.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return (T)method.invoke(target, parameters);
            }
            catch (NoSuchMethodException e) {
                thrown = e;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                thrown = e;
                break;
            }
        }
        throw UncheckedThrow.throwUnchecked(thrown);
    }

    static Field getDeclaredField(Object target, String name) throws NoSuchFieldException, SecurityException {
        Exception thrown = null;
        for (Class<?> current = target.getClass(); current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                thrown = e;
                continue;
            }
            catch (SecurityException e) {
                thrown = e;
                break;
            }
        }
        throw UncheckedThrow.throwUnchecked(thrown);
    }

    static <T> T getFieldValue(Object target, String name) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = LifecycleHooks.getDeclaredField(target, name);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    static void setFieldValue(Object target, String name, Object value) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = LifecycleHooks.getDeclaredField(target, name);
        field.setAccessible(true);
        field.set(target, value);
    }

    static Object callProxy(Callable<?> proxy) throws Exception {
        try {
            return proxy.call();
        }
        catch (InvocationTargetException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e.getCause());
        }
    }

    static {
        for (ShutdownListener listener : ServiceLoader.load(ShutdownListener.class)) {
            Runtime.getRuntime().addShutdownHook(LifecycleHooks.getShutdownHook(listener));
        }
    }
}

