/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class MutableTest
implements Test {
    private static final String DECLARED_ANNOTATIONS = "declaredAnnotations";
    private Class<? extends Throwable> expected;
    private long timeout;

    protected MutableTest(Test annotation) {
        this.expected = annotation.expected();
        this.timeout = annotation.timeout();
    }

    public Class<? extends Annotation> annotationType() {
        return MutableTest.class;
    }

    public Class<? extends Throwable> expected() {
        return this.expected;
    }

    public MutableTest setExpected(Class<? extends Throwable> expected) {
        this.expected = expected;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    public MutableTest setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public static MutableTest proxyFor(Method testMethod) {
        Test declared = testMethod.getDeclaredAnnotation(Test.class);
        if (declared instanceof MutableTest) {
            return (MutableTest)declared;
        }
        if (declared != null) {
            try {
                Field field = Executable.class.getDeclaredField(DECLARED_ANNOTATIONS);
                field.setAccessible(true);
                try {
                    Map map = (Map)field.get(testMethod);
                    MutableTest mutable = new MutableTest(declared);
                    map.put(Test.class, mutable);
                    return mutable;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new UnsupportedOperationException("Failed acquiring annotations map for method: " + testMethod, e);
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new UnsupportedOperationException("Failed acquiring [declaredAnnotations] field of Executable class", e);
            }
        }
        throw new IllegalArgumentException("Specified method is not a JUnit @Test: " + testMethod);
    }
}

