/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunWatcher;
import java.util.ServiceLoader;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class RunAnnouncer
extends RunListener {
    private static final ServiceLoader<RunWatcher> runWatcherLoader = ServiceLoader.load(RunWatcher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testStarted(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testFinished(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testFailure(atomicTest, failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testAssumptionFailure(atomicTest, (AssumptionViolatedException)failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testIgnored(atomicTest);
            }
        }
    }

    static AtomicTest getAtomicTest(Description description) {
        return new AtomicTest(Run.getThreadRunner(), description);
    }

    static AtomicTest getAtomicTest(Failure failure) {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTest(failure.getDescription());
        atomicTest.setThrowable(failure.getException());
        return atomicTest;
    }
}

