/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.CreateTest;
import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.common.base.UncheckedThrow;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;

public class RunReflectiveCall {
    private static final ServiceLoader<MethodWatcher> methodWatcherLoader;
    private static final ThreadLocal<Map<Integer, DepthGauge>> methodDepth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@This Object callable, @SuperCall Callable<?> proxy) throws Exception {
        Object runner = null;
        Object target = null;
        FrameworkMethod method = null;
        Object[] params = null;
        try {
            Object owner = LifecycleHooks.getFieldValue(callable, "this$0");
            if (owner instanceof FrameworkMethod) {
                method = (FrameworkMethod)owner;
                target = LifecycleHooks.getFieldValue(callable, "val$target");
                params = (Object[])LifecycleHooks.getFieldValue(callable, "val$params");
                if (RunReflectiveCall.isParticleMethod(method)) {
                    runner = target != null ? CreateTest.getRunnerForTarget(target) : Run.getThreadRunner();
                }
            } else {
                runner = owner;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException owner) {
            // empty catch block
        }
        if (method == null) {
            return LifecycleHooks.callProxy(proxy);
        }
        Object result = null;
        Throwable thrown = null;
        try {
            RunReflectiveCall.fireBeforeInvocation(runner, target, method, params);
            result = LifecycleHooks.callProxy(proxy);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            RunReflectiveCall.fireAfterInvocation(runner, target, method, thrown);
        }
        if (thrown != null) {
            throw UncheckedThrow.throwUnchecked((Throwable)thrown);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<MethodWatcher> getAttachedWatcher(Class<? extends MethodWatcher> watcherType) {
        Objects.requireNonNull(watcherType, "[watcherType] must be non-null");
        ServiceLoader<MethodWatcher> serviceLoader = methodWatcherLoader;
        synchronized (serviceLoader) {
            for (MethodWatcher watcher : methodWatcherLoader) {
                if (watcher.getClass() != watcherType) continue;
                return Optional.of(watcher);
            }
        }
        return Optional.empty();
    }

    public static boolean isParticleMethod(FrameworkMethod method) {
        return null != method.getAnnotation(Test.class) || null != method.getAnnotation(Before.class) || null != method.getAnnotation(After.class) || null != method.getAnnotation(BeforeClass.class) || null != method.getAnnotation(AfterClass.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fireBeforeInvocation(Object runner, Object target, FrameworkMethod method, Object ... params) {
        DepthGauge depthGauge;
        if (runner != null && method != null && 0 == (depthGauge = methodDepth.get().computeIfAbsent(RunReflectiveCall.methodHash(runner, method), k -> new DepthGauge())).increaseDepth()) {
            ServiceLoader<MethodWatcher> serviceLoader = methodWatcherLoader;
            synchronized (serviceLoader) {
                for (MethodWatcher watcher : methodWatcherLoader) {
                    watcher.beforeInvocation(runner, target, method, params);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fireAfterInvocation(Object runner, Object target, FrameworkMethod method, Throwable thrown) {
        DepthGauge depthGauge;
        if (runner != null && method != null && 0 == (depthGauge = methodDepth.get().computeIfAbsent(RunReflectiveCall.methodHash(runner, method), k -> new DepthGauge())).decreaseDepth()) {
            ServiceLoader<MethodWatcher> serviceLoader = methodWatcherLoader;
            synchronized (serviceLoader) {
                for (MethodWatcher watcher : methodWatcherLoader) {
                    watcher.afterInvocation(runner, target, method, thrown);
                }
            }
            return true;
        }
        return false;
    }

    public static int methodHash(Object runner, FrameworkMethod method) {
        return (Thread.currentThread().hashCode() * 31 + runner.hashCode()) * 31 + method.hashCode();
    }

    static {
        methodDepth = ThreadLocal.withInitial(HashMap::new);
        methodWatcherLoader = ServiceLoader.load(MethodWatcher.class);
    }
}

