/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.settings;

import com.nordstrom.common.base.UncheckedThrow;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsCore<T extends Enum<T>>
extends CompositeConfiguration {
    public static final String PROPS_FILE = "propsFile";
    private final Class<T> enumClass;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SystemConfiguration system = new SystemConfiguration();
    private Configuration properties;
    private MapConfiguration defaults;

    public SettingsCore(Class<T> enumClass) throws ConfigurationException, IOException {
        Map<String, String> defaultsMap;
        String path;
        Configurations configs;
        URL url;
        InputStream inputStream;
        this.enumClass = enumClass;
        this.addConfiguration((Configuration)this.system);
        this.properties = this.getStoredConfig();
        if (this.properties == null && (inputStream = this.getInputStream()) != null) {
            this.properties = new PropertiesConfiguration();
            ((PropertiesConfiguration)this.properties).read((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        if (this.properties == null && (url = this.getSettingsUrl()) != null) {
            try {
                configs = new Configurations();
                this.properties = configs.properties(url);
            }
            catch (ConfigurationException e) {
                this.propagateIfNotMissingFile(e);
                this.logger.debug("Optional settings not located at URL '{}'", (Object)url);
            }
        }
        if (this.properties == null && (path = this.getSettingsPath()) != null) {
            try {
                configs = new Configurations();
                this.properties = configs.properties(path);
            }
            catch (ConfigurationException e) {
                this.propagateIfNotMissingFile(e);
                this.logger.debug("Optional settings not located at path '{}'", (Object)path);
            }
        }
        if (this.properties != null) {
            this.addConfiguration(this.properties);
        }
        if ((defaultsMap = this.getDefaults()) != null && !defaultsMap.isEmpty()) {
            this.defaults = new MapConfiguration(defaultsMap);
            this.addConfiguration((Configuration)this.defaults);
        }
    }

    public Configuration getStoredConfig() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public URL getSettingsUrl() {
        return null;
    }

    public String getSettingsPath() {
        return null;
    }

    protected Map<String, String> getDefaults() {
        HashMap<String, String> defaultsMap = new HashMap<String, String>();
        for (Enum setting : (Enum[])this.enumClass.getEnumConstants()) {
            if (setting.val() == null) continue;
            defaultsMap.put(setting.key(), setting.val());
        }
        return defaultsMap;
    }

    protected void propagateIfNotMissingFile(ConfigurationException thrown) {
        String message = thrown.getMessage();
        if (message != null && message.contains("not locate")) {
            return;
        }
        throw UncheckedThrow.throwUnchecked((Throwable)thrown);
    }

    public static void injectProperties(String propsFile) {
        String path = System.getProperty(PROPS_FILE);
        if (path == null) {
            path = propsFile;
        }
        if (path != null) {
            try {
                Configurations configs = new Configurations();
                PropertiesConfiguration properties = configs.properties(path);
                Iterator i = properties.getKeys();
                while (i.hasNext()) {
                    String propName = (String)i.next();
                    if (System.getProperty(propName) != null) continue;
                    System.setProperty(propName, properties.getString(propName));
                }
            }
            catch (ConfigurationException e) {
                LoggerFactory.getLogger(SettingsCore.class).warn("Failure encountered injecting properties from path '{}'", (Object)path);
            }
        }
    }

    public static interface SettingsAPI {
        public String key();

        public String val();
    }
}

