/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.google.common.base.Optional;
import com.nordstrom.automation.testng.ArtifactType;
import com.nordstrom.common.file.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.testng.IConfigurationListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ArtifactCollector<T extends ArtifactType>
implements ITestListener,
IConfigurationListener {
    private static final String ARTIFACT_PATHS = "ArtifactPaths";
    private final T provider;

    public ArtifactCollector(T provider) {
        this.provider = provider;
    }

    public void onConfigurationSuccess(ITestResult result) {
    }

    public void onConfigurationFailure(ITestResult result) {
        this.captureArtifact(result);
    }

    public void onConfigurationSkip(ITestResult result) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ITestContext context) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.captureArtifact(result);
    }

    public void onTestFailure(ITestResult result) {
        this.captureArtifact(result);
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    public synchronized Optional<Path> captureArtifact(ITestResult result) {
        Path artifactPath;
        if (!((ArtifactType)this.provider).canGetArtifact(result)) {
            return Optional.absent();
        }
        byte[] artifact = ((ArtifactType)this.provider).getArtifact(result);
        if (artifact == null || artifact.length == 0) {
            return Optional.absent();
        }
        Path collectionPath = this.getCollectionPath(result);
        if (!collectionPath.toFile().exists()) {
            try {
                Files.createDirectories(collectionPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (((ArtifactType)this.provider).getLogger() != null) {
                    String messageTemplate = "Unable to create collection directory ({}); no artifact was captured";
                    ((ArtifactType)this.provider).getLogger().warn(messageTemplate, (Object)collectionPath, (Object)e);
                }
                return Optional.absent();
            }
        }
        try {
            artifactPath = PathUtils.getNextPath((Path)collectionPath, (String)ArtifactCollector.getArtifactBaseName(result), (String)((ArtifactType)this.provider).getArtifactExtension());
        }
        catch (IOException e) {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().warn("Unable to get output path; no artifact was captured", (Throwable)e);
            }
            return Optional.absent();
        }
        try {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().info("Saving captured artifact to ({}).", (Object)artifactPath);
            }
            Files.write(artifactPath, artifact, new OpenOption[0]);
        }
        catch (IOException e) {
            if (((ArtifactType)this.provider).getLogger() != null) {
                ((ArtifactType)this.provider).getLogger().warn("I/O error saving to ({}); no artifact was captured", (Object)artifactPath, (Object)e);
            }
            return Optional.absent();
        }
        ArtifactCollector.recordArtifactPath(artifactPath, result);
        return Optional.of((Object)artifactPath);
    }

    private Path getCollectionPath(ITestResult result) {
        ITestContext testContext = result.getTestContext();
        String outputDirectory = testContext.getOutputDirectory();
        Path collectionPath = Paths.get(outputDirectory, new String[0]);
        return collectionPath.resolve(((ArtifactType)this.provider).getArtifactPath(result));
    }

    private static String getArtifactBaseName(ITestResult result) {
        Object[] parameters = result.getParameters();
        if (parameters.length == 0) {
            return result.getName();
        }
        int hashcode = Arrays.deepHashCode(parameters);
        String hashStr = String.format("%08X", hashcode);
        return result.getName() + "-" + hashStr;
    }

    private static void recordArtifactPath(Path artifactPath, ITestResult result) {
        ArrayList<Path> artifactPaths = (ArrayList<Path>)result.getAttribute(ARTIFACT_PATHS);
        if (artifactPaths == null) {
            artifactPaths = new ArrayList<Path>();
            result.setAttribute(ARTIFACT_PATHS, artifactPaths);
        }
        artifactPaths.add(artifactPath);
    }

    public static synchronized Optional<List<Path>> retrieveArtifactPaths(ITestResult result) {
        List artifactPaths = (List)result.getAttribute(ARTIFACT_PATHS);
        if (artifactPaths != null) {
            return Optional.of((Object)artifactPaths);
        }
        return Optional.absent();
    }

    public T getArtifactProvider() {
        return this.provider;
    }
}

