/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DataProviders {
    private DataProviders() {
        throw new AssertionError((Object)"DataProviders is a static utility class that cannot be instantiated");
    }

    public static Iterator<Object[]> createIterator(Object ... providers) {
        ArrayList<Set<Object[]>> setList = new ArrayList<Set<Object[]>>();
        for (Object thisObj : providers) {
            if (thisObj instanceof Iterator) {
                HashSet<Object[]> thisSet = new HashSet<Object[]>();
                while (((Iterator)thisObj).hasNext()) {
                    thisSet.add((Object[])((Iterator)thisObj).next());
                }
                setList.add(thisSet);
                continue;
            }
            if (thisObj instanceof Object[][]) {
                setList.add(Sets.newHashSet((Object[])((Object[][])thisObj)));
                continue;
            }
            if (thisObj instanceof Object[]) {
                setList.add(Sets.newHashSet((Object[])DataProviders.unflatten((Object[])thisObj)));
                continue;
            }
            throw new IllegalArgumentException("Types of all arguments must be Object[][], Iterator<Object[]>, or Object[]");
        }
        return new CartesianDataProvider(setList);
    }

    public static Object[][] unflatten(Object[] flatArray) {
        Object[][] arrayOfArray = new Object[flatArray.length][];
        for (int thisIndex = 0; thisIndex < flatArray.length; ++thisIndex) {
            arrayOfArray[thisIndex] = new Object[]{flatArray[thisIndex]};
        }
        return arrayOfArray;
    }

    private static class CartesianDataProvider
    implements Iterator<Object[]> {
        private final Iterator<List<Object[]>> provider;

        CartesianDataProvider(List<Set<Object[]>> setList) {
            this.provider = Sets.cartesianProduct(setList).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.provider.hasNext();
        }

        @Override
        public Object[] next() {
            ArrayList<Object> dataList = new ArrayList<Object>();
            for (Object[] thisItem : this.provider.next()) {
                dataList.addAll(Arrays.asList(thisItem));
            }
            return dataList.toArray();
        }

        @Override
        public void remove() {
            this.provider.remove();
        }
    }
}

