/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.nordstrom.automation.testng.IInvokedMethodListenerEx;
import com.nordstrom.automation.testng.NoRetry;
import com.nordstrom.automation.testng.PropertyManager;
import com.nordstrom.automation.testng.TestNGConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.testng.IAnnotationTransformer;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;
import org.testng.annotations.ITestAnnotation;

public class ExecutionFlowController
implements IInvokedMethodListener,
IAnnotationTransformer {
    protected static final ThreadLocal<ITestResult> fromBefore = new InheritableThreadLocal<ITestResult>();
    protected static final ThreadLocal<ITestResult> fromMethod = new InheritableThreadLocal<ITestResult>();

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (testResult.getInstance() instanceof IInvokedMethodListenerEx) {
            ((IInvokedMethodListenerEx)testResult.getInstance()).afterInvocation(method, testResult);
        }
        if (method.getTestMethod().isBeforeMethodConfiguration()) {
            ITestResult lastResult = fromBefore.get();
            if (lastResult != null) {
                Map<String, Object> attributes = PropertyManager.extractAttributes(lastResult);
                PropertyManager.injectAttributes(attributes, testResult);
            }
            fromBefore.set(testResult);
        } else if (method.isTestMethod()) {
            fromMethod.set(testResult);
        } else if (method.getTestMethod().isAfterMethodConfiguration()) {
            // empty if block
        }
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!method.getTestMethod().isBeforeMethodConfiguration()) {
            if (method.isTestMethod()) {
                ITestResult lastResult = fromBefore.get();
                if (lastResult != null) {
                    Map<String, Object> attributes = PropertyManager.extractAttributes(lastResult);
                    PropertyManager.injectAttributes(attributes, testResult);
                    fromBefore.remove();
                }
            } else if (method.getTestMethod().isAfterMethodConfiguration()) {
                Map<String, Object> attributes = PropertyManager.extractAttributes(fromMethod.get());
                PropertyManager.injectAttributes(attributes, testResult);
            }
        }
        if (testResult.getInstance() instanceof IInvokedMethodListenerEx) {
            ((IInvokedMethodListenerEx)testResult.getInstance()).beforeInvocation(method, testResult);
        }
    }

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        if (testMethod != null) {
            Class<IRetryAnalyzer> retryAnalyzerClass;
            long defaultTimeout;
            TestNGConfig config = TestNGConfig.getConfig();
            if (config.containsKey(TestNGConfig.TestNGSettings.TEST_TIMEOUT.key()) && (defaultTimeout = config.getLong(TestNGConfig.TestNGSettings.TEST_TIMEOUT.key())) > annotation.getTimeOut()) {
                annotation.setTimeOut(defaultTimeout);
            }
            if (annotation.getRetryAnalyzer() == null && (retryAnalyzerClass = config.getRetryAnalyzerClass()) != null) {
                NoRetry noRetryOnMethod = testMethod.getAnnotation(NoRetry.class);
                NoRetry noRetryOnClass = testMethod.getDeclaringClass().getAnnotation(NoRetry.class);
                if (noRetryOnMethod == null && noRetryOnClass == null) {
                    annotation.setRetryAnalyzer(retryAnalyzerClass);
                }
            }
        }
    }
}

