/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.nordstrom.automation.testng.RedactValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.ITestResult;

class InvocationRecord {
    final Method method;
    final String suiteName;
    final String testName;
    final String className;
    final String methodName;
    final Object[] parameters;

    InvocationRecord(ITestResult result) {
        this.method = result.getMethod().getConstructorOrMethod().getMethod();
        this.suiteName = result.getTestContext().getSuite().getName();
        this.testName = result.getTestContext().getName();
        this.className = result.getMethod().getRealClass().getName();
        this.methodName = result.getMethod().getMethodName();
        this.parameters = result.getParameters();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.suiteName == null ? 0 : this.suiteName.hashCode());
        result = 31 * result + (this.testName == null ? 0 : this.testName.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationRecord)) {
            return false;
        }
        InvocationRecord other = (InvocationRecord)obj;
        if (this.suiteName == null ? other.suiteName != null : !this.suiteName.equals(other.suiteName)) {
            return false;
        }
        if (this.testName == null ? other.testName != null : !this.testName.equals(other.testName)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }

    public static String getQualifiedName(Method method) {
        String methodSig = method.toString();
        int endIndex = methodSig.lastIndexOf(40);
        int midIndex = methodSig.lastIndexOf(46, endIndex - 1);
        int beginIndex = methodSig.lastIndexOf(46, midIndex - 1) + 1;
        return methodSig.substring(beginIndex, endIndex);
    }

    public String toString() {
        int len = this.parameters.length;
        StringBuilder builder = new StringBuilder(InvocationRecord.getQualifiedName(this.method)).append('(');
        if (len > 0) {
            int i = 0;
            Annotation[][] methodParms = this.method.getParameterAnnotations();
            while (true) {
                if (InvocationRecord.isRedacted(methodParms[i])) {
                    builder.append("|:").append("arg" + i).append(":|");
                } else {
                    builder.append(this.parameters[i]);
                }
                if (++i == len) break;
                builder.append(", ");
            }
        }
        return builder.append(')').toString();
    }

    private static boolean isRedacted(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(RedactValue.class)) continue;
            return true;
        }
        return false;
    }
}

