/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.nordstrom.automation.testng.LinkedListener;
import com.nordstrom.automation.testng.LinkedListeners;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.testng.IAnnotationTransformer;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.ITestAnnotation;

public class ListenerChain
implements IAnnotationTransformer,
IExecutionListener,
ISuiteListener,
IConfigurationListener,
IInvokedMethodListener,
ITestListener,
IMethodInterceptor,
IClassListener {
    private Set<Class<?>> markedClasses = Collections.synchronizedSet(new HashSet());
    private Set<Class<? extends ITestNGListener>> listenerSet = Collections.synchronizedSet(new HashSet());
    private List<ITestNGListener> listeners = new ArrayList<ITestNGListener>();
    private List<IAnnotationTransformer> annotationXformers = new ArrayList<IAnnotationTransformer>();
    private List<IExecutionListener> executionListeners = new ArrayList<IExecutionListener>();
    private List<ISuiteListener> suiteListeners = new ArrayList<ISuiteListener>();
    private List<IConfigurationListener> configListeners = new ArrayList<IConfigurationListener>();
    private List<IInvokedMethodListener> methodListeners = new ArrayList<IInvokedMethodListener>();
    private List<ITestListener> testListeners = new ArrayList<ITestListener>();
    private List<IMethodInterceptor> methodInterceptors = new ArrayList<IMethodInterceptor>();
    private List<IClassListener> classListeners = new ArrayList<IClassListener>();
    private static final String LISTENER_CHAIN = "ListenerChain";

    public ListenerChain() {
        for (LinkedListener listener : ServiceLoader.load(LinkedListener.class)) {
            this.attachListener(null, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(ITestAnnotation annotation, Class testClass, Constructor testCtor, Method testMethod) {
        this.attachListeners(testClass, testCtor, testMethod);
        List<IAnnotationTransformer> list = this.annotationXformers;
        synchronized (list) {
            for (IAnnotationTransformer annotationXformer : this.annotationXformers) {
                annotationXformer.transform(annotation, testClass, testCtor, testMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(IConfigurationAnnotation annotation, Class testClass, Constructor testCtor, Method testMethod) {
        this.attachListeners(testClass, testCtor, testMethod);
        List<IAnnotationTransformer> list = this.annotationXformers;
        synchronized (list) {
            for (IAnnotationTransformer annotationXformer : this.annotationXformers) {
                annotationXformer.transform(annotation, testClass, testCtor, testMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(IDataProviderAnnotation annotation, Method method) {
        this.attachListeners(method);
        List<IAnnotationTransformer> list = this.annotationXformers;
        synchronized (list) {
            for (IAnnotationTransformer annotationXformer : this.annotationXformers) {
                annotationXformer.transform(annotation, method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(IFactoryAnnotation annotation, Method method) {
        this.attachListeners(method);
        List<IAnnotationTransformer> list = this.annotationXformers;
        synchronized (list) {
            for (IAnnotationTransformer annotationXformer : this.annotationXformers) {
                annotationXformer.transform(annotation, method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(IListenersAnnotation annotation, Class testClass) {
        this.attachListeners(testClass);
        List<IAnnotationTransformer> list = this.annotationXformers;
        synchronized (list) {
            for (IAnnotationTransformer annotationXformer : this.annotationXformers) {
                annotationXformer.transform(annotation, testClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionStart() {
        List<IExecutionListener> list = this.executionListeners;
        synchronized (list) {
            for (IExecutionListener executionListener : this.executionListeners) {
                executionListener.onExecutionStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionFinish() {
        List<IExecutionListener> list = this.executionListeners;
        synchronized (list) {
            for (IExecutionListener executionListener : this.executionListeners) {
                executionListener.onExecutionFinish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(ISuite suite) {
        suite.setAttribute(LISTENER_CHAIN, (Object)this);
        List<ISuiteListener> list = this.suiteListeners;
        synchronized (list) {
            for (ISuiteListener suiteListener : Lists.reverse(this.suiteListeners)) {
                suiteListener.onStart(suite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ISuite suite) {
        List<ISuiteListener> list = this.suiteListeners;
        synchronized (list) {
            for (ISuiteListener suiteListener : this.suiteListeners) {
                suiteListener.onFinish(suite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationSuccess(ITestResult itr) {
        List<IConfigurationListener> list = this.configListeners;
        synchronized (list) {
            for (IConfigurationListener configListener : this.configListeners) {
                configListener.onConfigurationSuccess(itr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationFailure(ITestResult itr) {
        List<IConfigurationListener> list = this.configListeners;
        synchronized (list) {
            for (IConfigurationListener configListener : this.configListeners) {
                configListener.onConfigurationFailure(itr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationSkip(ITestResult itr) {
        List<IConfigurationListener> list = this.configListeners;
        synchronized (list) {
            for (IConfigurationListener configListener : this.configListeners) {
                configListener.onConfigurationSkip(itr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeConfiguration(ITestResult tr) {
        List<IConfigurationListener> list = this.configListeners;
        synchronized (list) {
            for (IConfigurationListener configListener : Lists.reverse(this.configListeners)) {
                configListener.beforeConfiguration(tr);
            }
        }
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        List<IInvokedMethodListener> list = this.methodListeners;
        synchronized (list) {
            for (IInvokedMethodListener methodListener : Lists.reverse(this.methodListeners)) {
                methodListener.beforeInvocation(method, testResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        List<IInvokedMethodListener> list = this.methodListeners;
        synchronized (list) {
            for (IInvokedMethodListener methodListener : this.methodListeners) {
                methodListener.afterInvocation(method, testResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestStart(ITestResult result) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : Lists.reverse(this.testListeners)) {
                testListener.onTestStart(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestSuccess(ITestResult result) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : this.testListeners) {
                testListener.onTestSuccess(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestFailure(ITestResult result) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : this.testListeners) {
                testListener.onTestFailure(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestSkipped(ITestResult result) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : this.testListeners) {
                testListener.onTestSkipped(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : this.testListeners) {
                testListener.onTestFailedButWithinSuccessPercentage(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(ITestContext context) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : Lists.reverse(this.testListeners)) {
                testListener.onStart(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ITestContext context) {
        List<ITestListener> list = this.testListeners;
        synchronized (list) {
            for (ITestListener testListener : this.testListeners) {
                testListener.onFinish(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        List<IMethodInterceptor> list = this.methodInterceptors;
        synchronized (list) {
            for (IMethodInterceptor interceptor : this.methodInterceptors) {
                methods = interceptor.intercept(methods, context);
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforeClass(ITestClass testClass) {
        List<IClassListener> list = this.classListeners;
        synchronized (list) {
            for (IClassListener classListener : Lists.reverse(this.classListeners)) {
                classListener.onBeforeClass(testClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAfterClass(ITestClass testClass) {
        List<IClassListener> list = this.classListeners;
        synchronized (list) {
            for (IClassListener classListener : this.classListeners) {
                classListener.onAfterClass(testClass);
            }
        }
    }

    public static <T extends ITestNGListener> Optional<T> getAttachedListener(ITestResult result, Class<T> listenerType) {
        Objects.requireNonNull(result, "[result] must be non-null");
        return ListenerChain.getAttachedListener(result.getTestContext(), listenerType);
    }

    public static <T extends ITestNGListener> Optional<T> getAttachedListener(ITestContext context, Class<T> listenerType) {
        Objects.requireNonNull(context, "[context] must be non-null");
        return ListenerChain.getAttachedListener(context.getSuite(), listenerType);
    }

    public static <T extends ITestNGListener> Optional<T> getAttachedListener(ISuite suite, Class<T> listenerType) {
        Objects.requireNonNull(suite, "[suite] must be non-null");
        Objects.requireNonNull(listenerType, "[listenerType] must be non-null");
        ListenerChain chain = (ListenerChain)suite.getAttribute(LISTENER_CHAIN);
        Objects.requireNonNull(chain, "Specified suite has no ListenerChain");
        return chain.getAttachedListener(listenerType);
    }

    public <T extends ITestNGListener> Optional<T> getAttachedListener(Class<T> listenerType) {
        for (ITestNGListener listener : this.listeners) {
            if (listener.getClass() != listenerType) continue;
            return Optional.of((Object)listener);
        }
        return Optional.absent();
    }

    private void attachListeners(Method testMethod) {
        if (testMethod != null) {
            this.processLinkedListeners(testMethod.getDeclaringClass());
        }
    }

    private void attachListeners(Class<?> testClass, Constructor<?> testCtor, Method testMethod) {
        if (testClass != null) {
            this.processLinkedListeners(testClass);
        } else if (testCtor != null) {
            this.processLinkedListeners(testCtor.getDeclaringClass());
        } else if (testMethod != null) {
            this.processLinkedListeners(testMethod.getDeclaringClass());
        }
    }

    private void attachListeners(Class<?> testClass) {
        if (testClass != null) {
            this.processLinkedListeners(testClass);
        }
    }

    private void processLinkedListeners(Class<?> testClass) {
        Class<?> markedClass;
        Objects.requireNonNull(testClass, "[testClass] must be non-null");
        LinkedListeners annotation = testClass.getAnnotation(LinkedListeners.class);
        if (null != annotation && !this.markedClasses.contains(markedClass = ListenerChain.getMarkedClass(testClass))) {
            this.markedClasses.add(markedClass);
            for (Class<? extends ITestNGListener> listener : annotation.value()) {
                this.attachListener(listener, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachListener(Class<? extends ITestNGListener> listenerTyp, ITestNGListener listenerObj) {
        Class<Object> type;
        ITestNGListener object;
        if (listenerTyp == null && listenerObj == null) {
            throw new IllegalArgumentException("Neither [listenerTyp] nor [listenerObj] was specified");
        }
        if (listenerObj != null) {
            object = listenerObj;
            type = listenerObj.getClass();
        } else {
            object = null;
            type = listenerTyp;
        }
        if (!this.listenerSet.contains(type)) {
            this.listenerSet.add(type);
            if (object == null) {
                try {
                    object = (ITestNGListener)type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Unable to instantiate listener: " + type.getName(), e);
                }
            }
            List<ITestNGListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(object);
            }
            if (object instanceof IAnnotationTransformer) {
                list = this.annotationXformers;
                synchronized (list) {
                    this.annotationXformers.add((IAnnotationTransformer)object);
                }
            }
            if (object instanceof IExecutionListener) {
                list = this.executionListeners;
                synchronized (list) {
                    this.executionListeners.add((IExecutionListener)object);
                }
            }
            if (object instanceof ISuiteListener) {
                list = this.suiteListeners;
                synchronized (list) {
                    this.suiteListeners.add((ISuiteListener)object);
                }
            }
            if (object instanceof IConfigurationListener) {
                list = this.configListeners;
                synchronized (list) {
                    this.configListeners.add((IConfigurationListener)object);
                }
            }
            if (object instanceof IInvokedMethodListener) {
                list = this.methodListeners;
                synchronized (list) {
                    this.methodListeners.add((IInvokedMethodListener)object);
                }
            }
            if (object instanceof ITestListener) {
                list = this.testListeners;
                synchronized (list) {
                    this.testListeners.add((ITestListener)object);
                }
            }
            if (object instanceof IMethodInterceptor) {
                list = this.methodInterceptors;
                synchronized (list) {
                    this.methodInterceptors.add((IMethodInterceptor)object);
                }
            }
            if (object instanceof IClassListener) {
                list = this.classListeners;
                synchronized (list) {
                    this.classListeners.add((IClassListener)object);
                }
            }
        }
    }

    private static Class<?> getMarkedClass(Class<?> testClass) {
        for (Class<?> thisClass = testClass; thisClass != null; thisClass = thisClass.getSuperclass()) {
            for (Annotation annotation : thisClass.getDeclaredAnnotations()) {
                if (!annotation.annotationType().isAssignableFrom(LinkedListeners.class)) continue;
                return thisClass;
            }
        }
        return null;
    }
}

