/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.nordstrom.automation.testng.InvocationRecord;
import com.nordstrom.automation.testng.TestNGConfig;
import com.nordstrom.common.base.ExceptionUnwrapper;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryManager
implements IRetryAnalyzer {
    private final TestNGConfig config;
    private final Map<InvocationRecord, Integer> invocations;
    private final ServiceLoader<IRetryAnalyzer> retryAnalyzerLoader;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RetryManager() {
        this.config = TestNGConfig.getConfig();
        this.invocations = new ConcurrentHashMap<InvocationRecord, Integer>();
        this.retryAnalyzerLoader = ServiceLoader.load(IRetryAnalyzer.class);
    }

    public boolean retry(ITestResult result) {
        boolean doRetry = false;
        result.setThrowable(ExceptionUnwrapper.unwrap((Throwable)result.getThrowable()));
        InvocationRecord invocation = new InvocationRecord(result);
        Integer count = this.invocations.get(invocation);
        if (count == null) {
            count = this.config.getInt(TestNGConfig.TestNGSettings.MAX_RETRY.key());
        }
        if (count > 0) {
            count = count - 1;
            this.invocations.put(invocation, count);
            doRetry = this.isRetriable(result);
            if (doRetry) {
                this.logger.warn("### RETRY ### [{}/{}] {}", new Object[]{invocation.suiteName, invocation.testName, invocation});
            }
        }
        return doRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRetriable(ITestResult result) {
        ServiceLoader<IRetryAnalyzer> serviceLoader = this.retryAnalyzerLoader;
        synchronized (serviceLoader) {
            for (IRetryAnalyzer analyzer : this.retryAnalyzerLoader) {
                if (!analyzer.retry(result)) continue;
                return true;
            }
        }
        return false;
    }
}

