/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import com.nordstrom.automation.settings.SettingsCore;
import com.nordstrom.common.base.UncheckedThrow;
import java.io.IOException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;
import org.testng.Reporter;

public class TestNGConfig
extends SettingsCore<TestNGSettings> {
    private static final String SETTINGS_FILE = "testng.properties";
    private static final String TESTNG_CONFIG = "TESTNG_CONFIG";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestNGConfig.class);
    private static final ThreadLocal<TestNGConfig> testNGConfig = new InheritableThreadLocal<TestNGConfig>(){

        @Override
        protected TestNGConfig initialValue() {
            try {
                return new TestNGConfig();
            }
            catch (IOException | ConfigurationException e) {
                throw UncheckedThrow.throwUnchecked((Throwable)e);
            }
        }
    };

    public TestNGConfig() throws ConfigurationException, IOException {
        super(TestNGSettings.class);
    }

    public static TestNGConfig getConfig() {
        return TestNGConfig.getConfig(Reporter.getCurrentTestResult());
    }

    public static TestNGConfig getConfig(ITestResult testResult) {
        if (testResult == null) {
            return testNGConfig.get();
        }
        TestNGConfig config = (TestNGConfig)((Object)testResult.getAttribute(TESTNG_CONFIG));
        if (config == null) {
            config = testNGConfig.get();
            testResult.setAttribute(TESTNG_CONFIG, (Object)config);
        }
        return config;
    }

    public Class<IRetryAnalyzer> getRetryAnalyzerClass() {
        if (this.getInt(TestNGSettings.MAX_RETRY.key()) > 0) {
            String retryAnalyzerName = this.getString(TestNGSettings.RETRY_ANALYZER.key());
            if (retryAnalyzerName == null || retryAnalyzerName.isEmpty()) {
                LOGGER.warn("Value of setting [{}] is undefined", (Object)TestNGSettings.RETRY_ANALYZER.key());
            } else {
                try {
                    return Class.forName(retryAnalyzerName);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Specified retry analyzer class '{}' not found", (Object)retryAnalyzerName);
                }
                catch (ClassCastException e) {
                    LOGGER.warn("Specified retry analyzer '{}' does not implement IRetryAnalyzer", (Object)retryAnalyzerName);
                }
            }
        }
        return null;
    }

    public String getSettingsPath() {
        return SETTINGS_FILE;
    }

    public static enum TestNGSettings implements SettingsCore.SettingsAPI
    {
        TEST_TIMEOUT("testng.timeout.test", null),
        RETRY_ANALYZER("testng.retry.analyzer", "com.nordstrom.automation.testng.RetryManager"),
        MAX_RETRY("testng.max.retry", "0");

        private String propertyName;
        private String defaultValue;

        private TestNGSettings(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.propertyName;
        }

        public String val() {
            return this.defaultValue;
        }
    }
}

