/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.testng;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.testng.ITestResult;

public class TrackedObject<T> {
    private String key;
    private T value;
    private Set<ITestResult> references = new HashSet<ITestResult>();

    public TrackedObject(ITestResult result, String key, T value) {
        this.key = key;
        this.value = value;
        this.addRef(result);
    }

    public static <T> TrackedObject<T> create(ITestResult result, String key, T value) {
        return new TrackedObject<T>(result, key, value);
    }

    public T getValue() {
        return this.value;
    }

    public void addRef(ITestResult result) {
        this.references.add(result);
        result.setAttribute(this.key, (Object)this);
    }

    public boolean release(ITestResult result) {
        if (this.references.contains(result)) {
            result.setAttribute(this.key, null);
            result.removeAttribute(this.key);
            this.references.remove(result);
            if (this.references.isEmpty()) {
                this.value = null;
            }
            return true;
        }
        return false;
    }

    public T release() {
        T local = this.value;
        Iterator<ITestResult> iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ITestResult result = iterator.next();
            result.setAttribute(this.key, null);
            result.removeAttribute(this.key);
            iterator.remove();
        }
        this.value = null;
        return local;
    }
}

